/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.commons.util.range;

import com.google.common.collect.Range;
import com.google.common.collect.RangeMap;
import com.google.common.collect.TreeRangeMap;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.function.Supplier;

public class RangeMapUtils {
    public static <K extends Comparable<K>, V, C extends Collection<V>> void merge(RangeMap<K, C> rangeMap, Range<K> range, V value, Supplier<C> newCollection) {
        RangeMapUtils.merge(rangeMap, range, Collections.singleton(value), newCollection);
    }

    public static <K extends Comparable<K>, V, C extends Collection<V>> void merge(RangeMap<K, C> rangeMap, Range<K> range, Collection<V> values, Supplier<C> newCollection) {
        Collection copy = (Collection)newCollection.get();
        copy.addAll(values);
        rangeMap.merge(range, (Object)copy, (priorValues, additions) -> {
            Collection r = (Collection)newCollection.get();
            r.addAll(priorValues);
            r.addAll(additions);
            return r;
        });
    }

    protected static <K extends Comparable<K>> RangeMap<K, ?> create(Collection<Range<K>> ranges) {
        TreeRangeMap result = TreeRangeMap.create();
        Integer nothing = 0;
        ranges.forEach(arg_0 -> RangeMapUtils.lambda$create$0((RangeMap)result, nothing, arg_0));
        return result;
    }

    public static <K extends Comparable<K>, V> void split(RangeMap<K, V> ranges, Iterable<K> splitPoints) {
        for (Comparable splitPoint : splitPoints) {
            RangeMapUtils.split(ranges, splitPoint);
        }
    }

    public static <K extends Comparable<K>, V> void split(RangeMap<K, V> ranges, K splitPoint) {
        Map.Entry e = ranges.getEntry(splitPoint);
        if (e != null) {
            Range before = (Range)e.getKey();
            Object value = e.getValue();
            Range lhs = before.intersection(Range.lessThan(splitPoint));
            Range rhs = before.intersection(Range.atLeast(splitPoint));
            if (!lhs.isEmpty() && !rhs.isEmpty()) {
                ranges.remove(before);
                ranges.put(lhs, value);
                ranges.put(rhs, value);
            }
        }
    }

    private static /* synthetic */ void lambda$create$0(RangeMap result, Integer nothing, Range range) {
        result.put(range, (Object)nothing);
    }
}

