/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.commons.util.range;

import com.google.common.collect.BoundType;
import org.aksw.commons.util.range.BoundTypeUtils;

public class Endpoint<T> {
    protected T value;
    protected BoundType boundType;

    public Endpoint(T value, BoundType boundType) {
        this.value = value;
        this.boundType = boundType;
    }

    public static <T> Endpoint<T> open(T value) {
        return Endpoint.of(value, BoundType.OPEN);
    }

    public static <T> Endpoint<T> closed(T value) {
        return Endpoint.of(value, BoundType.CLOSED);
    }

    public static <T> Endpoint<T> of(T value, BoundType boundType) {
        return new Endpoint<T>(value, boundType);
    }

    public T getValue() {
        return this.value;
    }

    public BoundType getBoundType() {
        return this.boundType;
    }

    public Endpoint<T> toggleBoundType() {
        return this.value == null ? this : new Endpoint<T>(this.value, BoundTypeUtils.toggle(this.boundType));
    }

    public boolean hasValue() {
        return this.value != null;
    }

    public String toString() {
        return String.valueOf(this.boundType) + " " + String.valueOf(this.value);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.boundType == null ? 0 : this.boundType.hashCode());
        result = 31 * result + (this.value == null ? 0 : this.value.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Endpoint other = (Endpoint)obj;
        if (this.boundType != other.boundType) {
            return false;
        }
        return !(this.value == null ? other.value != null : !this.value.equals(other.value));
    }
}

