/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.commons.util.range;

import java.util.Comparator;
import java.util.Objects;
import org.aksw.commons.util.range.Cmp;

public class CmpFactory<T> {
    private static final Cmp<?> MIN = new CmpMin();
    private static final Cmp<?> MAX = new CmpMax();
    protected final Comparator<T> comparator;

    public CmpFactory(Comparator<T> comparator) {
        this.comparator = comparator;
    }

    public static <T> CmpFactory<T> of(Comparator<T> comparator) {
        return new CmpFactory<T>(comparator);
    }

    public Cmp<T> wrap(T value) {
        return new CmpValue<T>(this.comparator, value);
    }

    public Cmp<T> minValue() {
        return MIN;
    }

    public Cmp<T> maxValue() {
        return MAX;
    }

    public static class CmpValue<T>
    implements Cmp<T> {
        protected final T value;
        protected final Comparator<T> comparator;

        @Override
        public boolean isMin() {
            return false;
        }

        @Override
        public boolean isMax() {
            return false;
        }

        @Override
        public boolean hasValue() {
            return true;
        }

        public CmpValue(Comparator<T> comparator, T value) {
            this.comparator = comparator;
            this.value = value;
        }

        @Override
        public T getValue() {
            return this.value;
        }

        @Override
        public int compareTo(Cmp<T> o) {
            int result = o instanceof CmpMin ? 1 : (o instanceof CmpMax ? -1 : this.comparator.compare(this.value, ((CmpValue)o).value));
            return result;
        }

        public int hashCode() {
            return Objects.hash(this.value);
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            CmpValue other = (CmpValue)obj;
            return Objects.equals(this.value, other.value);
        }

        public String toString() {
            return "CmpValue [value=" + String.valueOf(this.value) + "]";
        }
    }

    public static class CmpMin<T>
    implements Cmp<T> {
        @Override
        public boolean isMin() {
            return true;
        }

        @Override
        public boolean isMax() {
            return false;
        }

        @Override
        public boolean hasValue() {
            return false;
        }

        @Override
        public T getValue() {
            throw new UnsupportedOperationException();
        }

        @Override
        public int compareTo(Cmp<T> o) {
            int result = o instanceof CmpMin ? 0 : -1;
            return result;
        }
    }

    public static class CmpMax<T>
    implements Cmp<T> {
        @Override
        public boolean isMin() {
            return false;
        }

        @Override
        public boolean isMax() {
            return true;
        }

        @Override
        public boolean hasValue() {
            return false;
        }

        @Override
        public T getValue() {
            throw new UnsupportedOperationException();
        }

        @Override
        public int compareTo(Cmp<T> o) {
            int result = o instanceof CmpMax ? 0 : 1;
            return result;
        }
    }
}

