/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.commons.util.memoize;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import org.aksw.commons.util.memoize.MemoizedFunction;

public class MemoizedFunctionImpl<I, O>
implements MemoizedFunction<I, O> {
    protected Map<I, O> cache;
    protected Function<I, O> delegate;

    public MemoizedFunctionImpl(Function<I, O> delegate, Map<I, O> cache) {
        this.delegate = delegate;
        this.cache = cache;
    }

    @Override
    public Map<I, O> getCache() {
        return this.cache;
    }

    @Override
    public void clearCache() {
        this.cache.clear();
    }

    @Override
    public O apply(I obj) {
        O result = this.cache.computeIfAbsent(obj, this.delegate);
        return result;
    }

    public static <I, O> MemoizedFunction<I, O> create(Function<I, O> delegate) {
        return new MemoizedFunctionImpl<I, O>(delegate, new ConcurrentHashMap());
    }

    public static <I, O> MemoizedFunction<I, O> createNonConcurrent(Function<I, O> delegate) {
        return new MemoizedFunctionImpl<I, O>(delegate, new HashMap());
    }
}

