/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.commons.util.memoize;

import java.util.AbstractMap;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.BiFunction;
import org.aksw.commons.util.memoize.MemoizedBiFunction;

public class MemoizedBiFunctionImpl<I1, I2, O>
implements MemoizedBiFunction<I1, I2, O> {
    protected Map<Map.Entry<I1, I2>, O> cache;
    protected BiFunction<I1, I2, O> delegate;

    public MemoizedBiFunctionImpl(BiFunction<I1, I2, O> delegate, Map<Map.Entry<I1, I2>, O> cache) {
        this.delegate = delegate;
        this.cache = cache;
    }

    @Override
    public Map<Map.Entry<I1, I2>, O> getCache() {
        return this.cache;
    }

    @Override
    public void clearCache() {
        this.cache.clear();
    }

    @Override
    public O apply(I1 a, I2 b) {
        Object result = this.cache.computeIfAbsent(new AbstractMap.SimpleEntry<I1, I2>(a, b), e -> this.delegate.apply(a, b));
        return (O)result;
    }

    public static <I1, I2, O> MemoizedBiFunction<I1, I2, O> create(BiFunction<I1, I2, O> delegate) {
        return new MemoizedBiFunctionImpl<I1, I2, O>(delegate, new ConcurrentHashMap());
    }

    public static <I1, I2, O> MemoizedBiFunction<I1, I2, O> createNonConcurrent(BiFunction<I1, I2, O> delegate) {
        return new MemoizedBiFunctionImpl<I1, I2, O>(delegate, new HashMap());
    }
}

