/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.commons.util.delegate;

import java.util.Optional;
import org.aksw.commons.util.delegate.Delegated;

public interface Unwrappable {
    default public <X> Optional<X> unwrap(Class<X> clazz, boolean reflexive) {
        Optional<Object> result;
        if (reflexive && clazz.isAssignableFrom(this.getClass())) {
            result = Optional.of(this);
        } else if (this instanceof Delegated) {
            Object delegate = ((Delegated)((Object)this)).delegate();
            result = Unwrappable.unwrap(delegate, clazz, true);
        } else {
            result = Optional.empty();
        }
        return result;
    }

    public static <X> Optional<X> unwrap(Object o, Class<X> clazz, boolean reflexive) {
        Optional<Object> result;
        Class<?> oClass = o.getClass();
        if (reflexive && clazz.isAssignableFrom(oClass)) {
            result = Optional.of(o);
        } else if (o instanceof Unwrappable) {
            result = ((Unwrappable)o).unwrap(clazz, true);
        } else if (o instanceof Delegated) {
            Object delegate = ((Delegated)o).delegate();
            result = Unwrappable.unwrap(delegate, clazz, true);
        } else {
            result = Optional.empty();
        }
        return result;
    }
}

