/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.commons.util.convert;

import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.aksw.commons.util.convert.ConvertFunctionRaw;
import org.aksw.commons.util.convert.ConverterRegistry;
import org.aksw.commons.util.memoize.MemoizedBiFunction;
import org.aksw.commons.util.memoize.MemoizedBiFunctionImpl;
import org.aksw.commons.util.reflect.ClassUtils;

public class ConverterRegistryImpl
implements ConverterRegistry {
    protected List<ConvertFunctionRaw> converters = new ArrayList<ConvertFunctionRaw>();
    protected MemoizedBiFunction<Class<?>, Class<?>, ConvertFunctionRaw> cachedFind = MemoizedBiFunctionImpl.create(this::findUncached);

    @Override
    public synchronized void register(ConvertFunctionRaw converter) {
        this.cachedFind.clearCache();
        this.converters.add(converter);
    }

    protected ConvertFunctionRaw findUncached(Class<?> src, Class<?> tgt) {
        List<ConvertFunctionRaw> converters = this.findMatches(src, tgt);
        if (converters.size() > 1) {
            throw new RuntimeException(String.format("Multiple converters found for (%s -> %s): %s", src, tgt, converters));
        }
        ConvertFunctionRaw result = converters.isEmpty() ? null : converters.iterator().next();
        return result;
    }

    protected List<ConvertFunctionRaw> findMatches(Class<?> src, Class<?> tgt) {
        List cands = this.converters.stream().map(c -> new AbstractMap.SimpleEntry<ConvertFunctionRaw, Integer>((ConvertFunctionRaw)c, ClassUtils.getDistance(src, c.getFrom()))).filter(e -> e.getValue() != null).sorted((a, b) -> ((Integer)a.getValue()).compareTo((Integer)b.getValue())).map(Map.Entry::getKey).collect(Collectors.toList());
        List<ConvertFunctionRaw> matches = cands.stream().map(c -> new AbstractMap.SimpleEntry<ConvertFunctionRaw, Integer>((ConvertFunctionRaw)c, ClassUtils.getDistance(c.getTo(), tgt))).filter(e -> e.getValue() != null).sorted((a, b) -> ((Integer)a.getValue()).compareTo((Integer)b.getValue())).map(Map.Entry::getKey).collect(Collectors.toList());
        return matches;
    }

    @Override
    public ConvertFunctionRaw getConverter(Class<?> from, Class<?> to) {
        return (ConvertFunctionRaw)this.cachedFind.apply(from, to);
    }
}

