/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.commons.util.convert;

import com.google.common.primitives.Primitives;
import java.math.BigDecimal;
import org.aksw.commons.util.convert.ConvertFunctionRaw;
import org.aksw.commons.util.convert.ConverterRegistry;
import org.aksw.commons.util.convert.ConverterRegistryImpl;
import org.apache.commons.lang3.ClassUtils;

public class ConverterRegistries {
    private static ConverterRegistry DFT_REGISTRY = null;

    public static ConvertFunctionRaw getConverterBoxed(ConverterRegistry registry, Class<?> from, Class<?> to) {
        ConvertFunctionRaw result = registry.getConverter(from, to);
        if (result == null) {
            Class wrappedFrom = Primitives.wrap(from);
            Class wrappedTo = Primitives.wrap(to);
            if (wrappedFrom != from || wrappedTo != to) {
                result = registry.getConverter(wrappedFrom, wrappedTo);
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static ConverterRegistry getDefaultConverterRegistry() {
        if (DFT_REGISTRY != null) return DFT_REGISTRY;
        Class<ConverterRegistry> clazz = ConverterRegistry.class;
        synchronized (ConverterRegistry.class) {
            if (DFT_REGISTRY != null) return DFT_REGISTRY;
            DFT_REGISTRY = new ConverterRegistryImpl();
            ConverterRegistries.addDefaultConversions(DFT_REGISTRY);
            // ** MonitorExit[var0] (shouldn't be in output)
            return DFT_REGISTRY;
        }
    }

    public static Object convert(ConverterRegistry converterRegistry, Object input, Class<?> target) {
        Object result;
        if (input == null) {
            result = null;
        } else {
            Class<?> inputClass = input.getClass();
            if (ClassUtils.isAssignable(inputClass, target)) {
                result = input;
            } else {
                ConvertFunctionRaw converter = ConverterRegistries.getConverterBoxed(converterRegistry, inputClass, target);
                if (converter == null) {
                    throw new RuntimeException(String.format("No converter registered from %1$s to %2$s", inputClass, target));
                }
                result = converter.convertRaw(input);
            }
        }
        return result;
    }

    public static void addDefaultConversions(ConverterRegistry registry) {
        registry.register(BigDecimal.class, Long.class, BigDecimal::longValueExact, BigDecimal::new).register(BigDecimal.class, Integer.class, BigDecimal::intValueExact, BigDecimal::new).register(BigDecimal.class, Short.class, BigDecimal::shortValueExact, BigDecimal::new).register(BigDecimal.class, Byte.class, BigDecimal::byteValueExact, BigDecimal::new).register(BigDecimal.class, Double.class, BigDecimal::doubleValue, BigDecimal::new).register(BigDecimal.class, Float.class, BigDecimal::floatValue, BigDecimal::new).register(String.class, CharSequence.class, str -> str, CharSequence::toString);
    }
}

