/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.commons.util.concurrent;

import java.util.concurrent.Callable;
import java.util.function.Consumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ScheduleOnce2 {
    private static final Logger logger = LoggerFactory.getLogger(ScheduleOnce2.class);
    protected Consumer<Callable<?>> executor;
    protected Callable<?> task;
    protected volatile long lastRequestTime = 0L;
    protected volatile Long lastTaskStartTime = 0L;
    protected final Object lock = new Object();

    public ScheduleOnce2(Consumer<Callable<?>> executor, Callable<?> task) {
        this.executor = executor;
        this.task = task;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void scheduleTask() {
        Object object = this.lock;
        synchronized (object) {
            ++this.lastRequestTime;
            if (this.lastTaskStartTime != null && this.lastRequestTime > this.lastTaskStartTime) {
                this.lastTaskStartTime = null;
                logger.info("Scheduled task");
                this.executor.accept(() -> {
                    Object object = this.lock;
                    synchronized (object) {
                        this.lastTaskStartTime = this.lastRequestTime;
                    }
                    logger.info("Running task " + String.valueOf(this.task));
                    try {
                        return this.task.call();
                    }
                    catch (Exception e) {
                        logger.warn("Task execution failed", (Throwable)e);
                        throw new RuntimeException(e);
                    }
                });
            }
        }
    }
}

