/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.commons.util.triplet;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.aksw.commons.util.Directed;
import org.aksw.commons.util.triplet.Triplet;
import org.aksw.commons.util.triplet.TripletImpl;

public class TripletPath<V, E> {
    protected V start;
    protected V end;
    protected List<Triplet<V, E>> triplets;

    public TripletPath(V start, V end, List<Triplet<V, E>> triples) {
        this.start = start;
        this.end = end;
        this.triplets = triples;
    }

    public Set<V> getNodeSet() {
        HashSet<V> result = new HashSet<V>();
        result.add(this.start);
        for (Triplet<V, E> t : this.triplets) {
            result.add(t.getSubject());
            result.add(t.getObject());
        }
        result.add(this.end);
        return result;
    }

    public V getNode(int i) {
        V result;
        int n = this.triplets.size();
        if (i == 0) {
            result = this.start;
        } else if (i == n) {
            result = this.end;
        } else if (i < n) {
            Triplet<V, E> tmp = this.triplets.get(i);
            result = tmp.getSubject();
        } else {
            throw new IndexOutOfBoundsException(i + " must not exceed " + n);
        }
        return result;
    }

    public boolean isCycleFree() {
        int m;
        int n = this.triplets.size();
        boolean result = n == (m = new HashSet<Triplet<V, E>>(this.triplets).size());
        return result;
    }

    public TripletPath<V, E> subPath(int fromIndex, int toIndex) {
        TripletPath<V, Directed<E>> tmp = TripletPath.makeDirected(this);
        V s = tmp.getNode(fromIndex);
        List<Triplet<V, Directed<E>>> ts = tmp.getTriplets().subList(fromIndex, toIndex);
        V e = ts.isEmpty() ? s : ts.get(ts.size() - 1).getObject();
        List<Triplet<V, E>> newTriplets = TripletPath.makeUndirected(ts);
        TripletPath<V, E> result = new TripletPath<V, E>(s, e, newTriplets);
        return result;
    }

    public V getStart() {
        return this.start;
    }

    public V getEnd() {
        return this.end;
    }

    public int getLength() {
        int result = this.triplets.size();
        return result;
    }

    public List<Triplet<V, E>> getTriplets() {
        return this.triplets;
    }

    public static <V, E> List<Triplet<V, E>> makeUndirected(List<Triplet<V, Directed<E>>> triplets) {
        List<Triplet<V, E>> result = triplets.stream().map(TripletImpl::makeUndirected).collect(Collectors.toList());
        return result;
    }

    public static <V, E> TripletPath<V, E> makeUndirected(TripletPath<V, Directed<E>> path) {
        List<Triplet<V, E>> tmp = TripletPath.makeUndirected(path.getTriplets());
        TripletPath<V, E> result = new TripletPath<V, E>(path.getStart(), path.getEnd(), tmp);
        return result;
    }

    public static <V, E> TripletPath<V, Directed<E>> makeDirected(TripletPath<V, E> path) {
        V s = path.getStart();
        List<Triplet<V, E>> triplets = path.getTriplets();
        ArrayList<Triplet<V, TripletImpl<V, Directed<E>>>> newTriplets = new ArrayList<Triplet<V, TripletImpl<V, Directed<E>>>>(triplets.size());
        for (Triplet<V, E> t : triplets) {
            V o;
            boolean reverse;
            if (t.getSubject().equals(s)) {
                reverse = false;
                o = t.getObject();
            } else if (t.getObject().equals(s)) {
                o = t.getSubject();
                reverse = true;
            } else {
                o = t.getObject();
                reverse = false;
            }
            Directed<E> p = new Directed<E>(t.getPredicate(), reverse);
            newTriplets.add(new TripletImpl<V, Directed<E>>(s, p, o));
            s = o;
        }
        TripletPath<V, E> result = new TripletPath<V, E>(path.getStart(), path.getEnd(), newTriplets);
        return result;
    }

    public TripletPath<V, E> reverse() {
        ArrayList<Triplet<V, E>> tmp = new ArrayList<Triplet<V, E>>(this.triplets);
        Collections.reverse(tmp);
        TripletPath<V, E> result = new TripletPath<V, E>(this.end, this.start, this.triplets);
        return result;
    }

    public TripletPath<V, E> concat(TripletPath<V, E> that) {
        ArrayList<Triplet<V, Triplet<V, E>>> triplets = new ArrayList<Triplet<V, Triplet<V, E>>>(this.triplets.size() + that.triplets.size());
        triplets.addAll(this.triplets);
        triplets.addAll(that.triplets);
        TripletPath<V, E> result = new TripletPath<V, E>(this.start, that.end, triplets);
        return result;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.end == null ? 0 : this.end.hashCode());
        result = 31 * result + (this.start == null ? 0 : this.start.hashCode());
        result = 31 * result + (this.triplets == null ? 0 : this.triplets.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        TripletPath other = (TripletPath)obj;
        if (this.end == null ? other.end != null : !this.end.equals(other.end)) {
            return false;
        }
        if (this.start == null ? other.start != null : !this.start.equals(other.start)) {
            return false;
        }
        return !(this.triplets == null ? other.triplets != null : !this.triplets.equals(other.triplets));
    }

    public String toString() {
        String result = "TripletPath[" + String.valueOf(this.start) + " -> " + String.valueOf(this.end) + ": " + String.valueOf(this.start);
        V current = this.start;
        for (Triplet<V, E> t : this.triplets) {
            Object dir;
            if (t.getSubject().equals(current)) {
                dir = "";
                current = t.getObject();
            } else if (t.getObject().equals(current)) {
                current = t.getSubject();
                dir = "^";
            } else {
                current = t.getObject();
                dir = "; " + String.valueOf(t.getSubject()) + " ";
            }
            result = result + " " + (String)dir + String.valueOf(t.getPredicate()) + " " + String.valueOf(current);
        }
        if (!current.equals(this.end)) {
            result = result + "; " + String.valueOf(this.end);
        }
        result = result + "]";
        return result;
    }
}

