/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.commons.util.stream;

import java.io.Serializable;
import java.util.function.Function;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.aksw.commons.lambda.serializable.SerializableFunction;

@FunctionalInterface
public interface StreamFunction<I, O>
extends Function<Stream<I>, Stream<O>>,
Serializable {
    @Override
    default public <X> StreamFunction<I, X> andThen(StreamFunction<O, X> next) {
        return in -> {
            Stream o = (Stream)this.apply(in);
            Stream r = (Stream)next.apply(o);
            return r;
        };
    }

    default public <X> StreamFunction<I, X> andThenMap(SerializableFunction<O, X> mapper) {
        return in -> {
            Stream o = (Stream)this.apply(in);
            Stream<Object> r = o.map(arg_0 -> mapper.apply(arg_0));
            return r;
        };
    }

    default public <X> StreamFunction<I, X> andThenFlatMap(SerializableFunction<O, ? extends Stream<X>> mapper) {
        return in -> {
            Stream o = (Stream)this.apply(in);
            Stream r = o.flatMap(x -> (Stream)mapper.apply(x));
            return r;
        };
    }

    default public <X> StreamFunction<I, X> andThenFlatMapIterable(SerializableFunction<O, ? extends Iterable<X>> mapper) {
        return in -> {
            Stream o = (Stream)this.apply(in);
            Stream r = o.flatMap(x -> StreamSupport.stream(((Iterable)mapper.apply(x)).spliterator(), false));
            return r;
        };
    }

    public static <I, O> StreamFunction<I, O> from(StreamFunction<I, O> rxfn) {
        return rxfn;
    }

    public static <X> StreamFunction<X, X> identity() {
        return x -> x;
    }

    public static <X> StreamFunction<X, X> identity(Class<X> cls) {
        return x -> x;
    }
}

