/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.commons.util.sink;

import org.aksw.commons.util.sink.BulkConsumer;
import org.aksw.commons.util.sink.Sink;

public class BulkingSink<T>
implements Sink<T> {
    protected T[] buffer;
    protected BulkConsumer delegate;
    protected int nextOffsetInBuffer;
    protected boolean isClosed = false;

    protected void ensureOpen() {
        if (this.isClosed) {
            throw new IllegalStateException("Sink is already closed");
        }
    }

    public BulkingSink(int bulkSize, BulkConsumer delegate) {
        if (bulkSize <= 0) {
            throw new IllegalArgumentException("Bulk size must be greater than 0");
        }
        this.buffer = new Object[bulkSize];
        this.delegate = delegate;
    }

    public static <T> BulkingSink<T> create(int bulkSize, BulkConsumer delegate) {
        return new BulkingSink<T>(bulkSize, delegate);
    }

    @Override
    public void accept(T item) {
        this.ensureOpen();
        this.buffer[this.nextOffsetInBuffer++] = item;
        if (this.nextOffsetInBuffer == this.buffer.length) {
            this.flushActual();
        }
    }

    @Override
    public void flush() {
        this.ensureOpen();
        this.flushActual();
    }

    protected void flushActual() {
        this.delegate.accept(this.buffer, 0, this.nextOffsetInBuffer);
        this.nextOffsetInBuffer = 0;
    }

    @Override
    public void close() {
        this.isClosed = true;
    }
}

