/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.commons.util.math;

import java.math.BigInteger;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.TreeSet;
import org.apache.commons.lang3.ArrayUtils;

public class Lehmer {
    public static <T> BigInteger lehmerValue(Collection<T> items, Comparator<T> comparator) {
        int[] lehmerCode = Lehmer.lehmerCode(items, comparator);
        BigInteger result = Lehmer.valueOfLehmerCode(lehmerCode);
        return result;
    }

    public static <T> int[] lehmerCode(Collection<T> items, Comparator<T> comparator) {
        LinkedHashSet<T> unique = new LinkedHashSet<T>(items);
        int n = unique.size();
        TreeSet<T> ordered = new TreeSet<T>(comparator);
        ordered.addAll(unique);
        HashMap<T, Integer> itemToIndex = new HashMap<T, Integer>();
        Iterator<T> it = ordered.iterator();
        int i = 0;
        while (it.hasNext()) {
            T item = it.next();
            itemToIndex.put(item, i);
            ++i;
        }
        int[] arr = new int[n];
        Iterator it2 = unique.iterator();
        int i2 = 0;
        while (it2.hasNext()) {
            int orderId;
            Object item = it2.next();
            arr[i2] = orderId = ((Integer)itemToIndex.get(item)).intValue();
            ++i2;
        }
        int[] lehmer = new int[n];
        int remaining = n;
        block2: for (int i3 = 0; i3 < n; ++i3) {
            int value = 0;
            for (int j = 0; j < remaining; ++j) {
                int cmp = arr[j];
                if (cmp > i3) {
                    ++value;
                    continue;
                }
                if (cmp != i3) continue;
                lehmer[i3] = value;
                ArrayUtils.removeElement((int[])arr, (int)j);
                --remaining;
                continue block2;
            }
        }
        return lehmer;
    }

    public static BigInteger valueOfLehmerCode(int[] lehmer) {
        int n = lehmer.length;
        int m = n - 1;
        BigInteger fac = BigInteger.valueOf(1L);
        BigInteger result = BigInteger.valueOf(0L);
        for (int i = 0; i < n; ++i) {
            int value = lehmer[m - i];
            BigInteger contrib = BigInteger.valueOf(value).multiply(fac);
            result = result.add(contrib);
            fac = BigInteger.valueOf(i + 1).multiply(fac);
        }
        return result;
    }
}

