/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.commons.util.list;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;

public class ListUtils {
    public static <T> T getOrNull(List<T> list, int i) {
        return ListUtils.getOrDefault(list, i, null);
    }

    public static <T> T getOrDefault(List<T> list, int i, T dflt) {
        T result = i >= list.size() ? dflt : list.get(i);
        return result;
    }

    public static <T> T lastOrNull(List<T> list) {
        return ListUtils.lastOrDefault(list, null);
    }

    public static <T> T lastOrDefault(List<T> list, T defaultValue) {
        return list.isEmpty() ? defaultValue : list.get(list.size() - 1);
    }

    public static <I, O> List<O> map(List<I> inList, Function<I, O> mapper) {
        ArrayList outList = new ArrayList(inList.size());
        inList.forEach(inItem -> {
            Object outItem = mapper.apply(inItem);
            outList.add(outItem);
        });
        return outList;
    }
}

