/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.commons.util.history;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Callable;

public class History {
    protected List<Callable<?>> mementos = new ArrayList();
    protected int currentPosition = -1;

    public void addMemento(Runnable memento) {
        this.addMemento(() -> {
            memento.run();
            return null;
        });
    }

    public void addMemento(Callable<?> memento) {
        ++this.currentPosition;
        this.mementos.subList(this.currentPosition, this.mementos.size()).clear();
        this.mementos.add(memento);
        try {
            memento.call();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void reset() {
        this.mementos.clear();
        this.currentPosition = -1;
    }

    public boolean canDoBackward() {
        return this.currentPosition > 0;
    }

    public boolean canDoForward() {
        int n = this.mementos.size();
        return this.currentPosition < n - 1;
    }

    protected Callable<?> backward() {
        --this.currentPosition;
        return this.mementos.get(this.currentPosition);
    }

    public boolean doBackward() {
        boolean result = this.canDoBackward();
        if (result) {
            Callable<?> callable = this.backward();
            try {
                callable.call();
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        return result;
    }

    public boolean doFoward() {
        boolean result = this.canDoForward();
        if (result) {
            Callable<?> callable = this.forward();
            try {
                callable.call();
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        return result;
    }

    protected Callable<?> forward() {
        ++this.currentPosition;
        return this.mementos.get(this.currentPosition);
    }

    public boolean isEmpty() {
        return this.mementos.isEmpty();
    }

    public int size() {
        return this.mementos.size();
    }
}

