/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.commons.util.function;

import java.io.Serializable;
import java.util.Collection;
import java.util.Objects;
import java.util.Set;
import java.util.function.Predicate;

public class PredicateContains<T>
implements Predicate<T>,
Serializable {
    private static final long serialVersionUID = 1L;
    protected Collection<T> items;

    protected PredicateContains(Collection<T> items) {
        this.items = Objects.requireNonNull(items);
    }

    public static <T> Predicate<T> of(T item) {
        return PredicateContains.of(Set.of(item));
    }

    public static <T> Predicate<T> of(Collection<T> items) {
        return new PredicateContains<T>(items);
    }

    public Collection<T> getItems() {
        return this.items;
    }

    @Override
    public boolean test(T item) {
        boolean result = this.items.contains(item);
        return result;
    }

    public String toString() {
        return "test if x in " + String.valueOf(this.items);
    }

    public int hashCode() {
        return Objects.hash(this.items);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        PredicateContains other = (PredicateContains)obj;
        return Objects.equals(this.items, other.items);
    }
}

