/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.commons.util.convert;

import java.util.function.Function;
import org.aksw.commons.util.convert.ConvertFunctionRawImpl;

public interface ConvertFunctionRaw {
    public Class<?> getFrom();

    public Class<?> getTo();

    public Function<Object, Object> getRawFunction();

    default public ConvertFunctionRaw andThen(ConvertFunctionRaw next) {
        Class<?> provided = this.getTo();
        Class<?> accepted = next.getFrom();
        if (!accepted.isAssignableFrom(provided)) {
            throw new RuntimeException(String.format("Cannot chain converters because the provided outgoing type %1$s is not accepted by %$2s", provided, accepted));
        }
        Class<?> newSrc = this.getFrom();
        Class<?> newTgt = next.getTo();
        return new ConvertFunctionRawImpl(newSrc, newTgt, in -> {
            Object tmp = this.convertRaw(in);
            Object r = next.convertRaw(tmp);
            return r;
        });
    }

    default public Object convertRaw(Object obj) {
        Function<Object, Object> fn = this.getRawFunction();
        Object result = fn.apply(obj);
        return result;
    }
}

