/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.commons.util.concurrent;

import com.google.common.util.concurrent.MoreExecutors;
import java.time.Duration;
import java.time.Instant;
import java.util.concurrent.Callable;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ScheduleOnce {
    private static final Logger logger = LoggerFactory.getLogger(ScheduleOnce.class);
    protected ScheduledExecutorService scheduledExecutorService;
    protected Duration execDelay;
    protected Callable<?> task;
    protected volatile Instant lastRequestTime = null;
    protected volatile Instant lastExecTime = Instant.ofEpochSecond(0L);
    protected final Object lock = new Object();

    public ScheduleOnce(ScheduledExecutorService scheduledExecutorService, Duration execDelay, Callable<?> task) {
        this.scheduledExecutorService = scheduledExecutorService;
        this.execDelay = execDelay;
        this.task = task;
    }

    public static ScheduleOnce scheduleOneTaskAtATime(Duration execDelay, Callable<?> task) {
        return new ScheduleOnce(MoreExecutors.getExitingScheduledExecutorService((ScheduledThreadPoolExecutor)new ScheduledThreadPoolExecutor(1)), execDelay, task);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void scheduleTask() {
        Object object = this.lock;
        synchronized (object) {
            this.lastRequestTime = Instant.now();
            if (this.lastExecTime != null && this.lastRequestTime.isAfter(this.lastExecTime)) {
                if (logger.isDebugEnabled()) {
                    logger.debug("Scheduled task with a delay of " + String.valueOf(this.execDelay));
                }
                this.lastExecTime = null;
                this.scheduledExecutorService.schedule(() -> {
                    if (logger.isDebugEnabled()) {
                        logger.debug("Running task " + String.valueOf(this.task));
                    }
                    Object object = this.lock;
                    synchronized (object) {
                        this.lastExecTime = Instant.now();
                    }
                    try {
                        return this.task.call();
                    }
                    catch (Exception e) {
                        if (logger.isWarnEnabled()) {
                            logger.warn("Task execution failed", (Throwable)e);
                        }
                        throw new RuntimeException(e);
                    }
                }, this.execDelay.toMillis(), TimeUnit.MILLISECONDS);
            }
        }
    }
}

