/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.commons.util.cache;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheStats;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;

public class CacheUtils {
    public static void invalidateAll(Cache<?, ?> cache) {
        if (cache != null) {
            cache.invalidateAll();
        }
    }

    public static <K, V> V getIfPresent(Cache<K, V> cache, K key) {
        Object result = cache != null ? cache.getIfPresent(key) : null;
        return (V)result;
    }

    public static <K, V> V get(Cache<K, V> cache, K key, Callable<? extends V> callable) {
        Object result;
        if (cache == null) {
            try {
                result = callable.call();
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        try {
            result = cache.get(key, callable);
        }
        catch (ExecutionException e) {
            throw new RuntimeException(e);
        }
        return result;
    }

    public static CacheStats stats(Cache<?, ?> cache) {
        return cache == null ? new CacheStats(0L, 0L, 0L, 0L, 0L, 0L) : cache.stats();
    }

    public static <K, V> CacheBuilder<K, V> recordStats(CacheBuilder<K, V> builder, boolean onOrOff) {
        return onOrOff ? builder.recordStats() : builder;
    }
}

