/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.commons.util.algebra;

import com.google.common.collect.Streams;
import com.google.common.graph.Traverser;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;

public interface ExprOps<E, V> {
    public List<E> getSubExprs(E var1);

    public E copy(E var1, List<E> var2);

    public boolean isFunction(E var1);

    public V asVar(E var1);

    public E varToExpr(V var1);

    public String toString(E var1);

    default public boolean isVar(E expr) {
        return this.asVar(expr) != null;
    }

    default public Set<V> varsMentioned(E expr) {
        return ExprOps.varsMentioned(this, expr);
    }

    public static <E, V> Set<V> varsMentioned(ExprOps<E, V> exprOps, E expr) {
        Set result = Streams.stream((Iterable)Traverser.forTree(exprOps::getSubExprs).depthFirstPostOrder(expr)).map(e -> exprOps.isVar(e) ? exprOps.asVar(e) : null).filter(Objects::nonNull).collect(Collectors.toCollection(LinkedHashSet::new));
        return result;
    }

    public static <E, V> Set<E> getLeafs(ExprOps<E, V> exprOps, E expr) {
        Set result = Streams.stream((Iterable)Traverser.forTree(exprOps::getSubExprs).depthFirstPostOrder(expr)).filter(e -> exprOps.getSubExprs(e).isEmpty()).collect(Collectors.toCollection(LinkedHashSet::new));
        return result;
    }

    public static <E, V> E replace(ExprOps<E, V> exprOps, E expr, Function<? super E, ? extends E> fn) {
        List<E> subExprsBefore = exprOps.getSubExprs(expr);
        ArrayList<E> subExprsAfter = new ArrayList<E>(subExprsBefore.size());
        boolean change = false;
        for (E subExprBefore : subExprsBefore) {
            E subExprAfter = ExprOps.replace(exprOps, subExprBefore, fn);
            subExprsAfter.add(subExprAfter);
            if (subExprAfter == subExprBefore) continue;
            change = true;
        }
        E arg = change ? exprOps.copy(expr, subExprsAfter) : expr;
        E result = fn.apply(arg);
        return result;
    }

    public static <E, V> E replaceTopDown(ExprOps<E, V> exprOps, E expr, Function<? super E, ? extends E> fn) {
        E result = fn.apply(expr);
        if (result == expr) {
            List<E> subExprsBefore = exprOps.getSubExprs(expr);
            ArrayList<E> subExprsAfter = new ArrayList<E>();
            boolean change = false;
            for (E subExprBefore : subExprsBefore) {
                E subExprAfter = ExprOps.replaceTopDown(exprOps, subExprBefore, fn);
                if (subExprAfter != subExprBefore) {
                    change = true;
                }
                subExprsAfter.add(subExprAfter);
            }
            if (change) {
                result = exprOps.copy(expr, subExprsAfter);
            }
        }
        return result;
    }
}

