/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.commons.util.traverse;

import com.google.common.collect.AbstractIterator;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collector;
import java.util.stream.Stream;

public class BreadthFirstSearchIterator<T, C extends Collection<T>>
extends AbstractIterator<C> {
    protected C current;
    protected Function<? super T, ? extends Stream<? extends T>> successorFn;
    protected Supplier<? extends Collector<T, ?, C>> collectorSupplier;
    protected Set<? super T> seen;
    protected C nextResult = null;

    public BreadthFirstSearchIterator(C current, Function<? super T, ? extends Stream<? extends T>> successorFn, Supplier<? extends Collector<T, ?, C>> collectorSupplier) {
        this.current = current;
        this.successorFn = successorFn;
        this.collectorSupplier = collectorSupplier;
        this.seen = new HashSet<T>();
    }

    protected C computeNext() {
        Object result;
        if (this.current.isEmpty()) {
            result = (Collection)this.endOfData();
        } else {
            result = this.current;
            Collector<T, ?, C> collector = this.collectorSupplier.get();
            this.current = (Collection)this.current.stream().flatMap(item -> this.successorFn.apply(item).filter(x -> !this.seen.contains(x))).collect(collector);
        }
        return result;
    }
}

