/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.commons.util.string;

import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.function.Predicate;
import org.aksw.commons.util.string.FileName;
import org.aksw.commons.util.string.FileNameImpl;
import org.aksw.commons.util.string.FileNameUtils;

public class FileNameParser {
    protected Predicate<String> isContent;
    protected Predicate<String> isEncoding;

    protected FileNameParser(Predicate<String> isContent, Predicate<String> isEncoding) {
        this.isContent = isContent;
        this.isEncoding = isEncoding;
    }

    public static FileNameParser of(Predicate<String> isContent, Predicate<String> isEncoding) {
        return new FileNameParser(isContent, isEncoding);
    }

    public FileName parse(String filename) {
        int i;
        List<String> parts = FileNameUtils.deconstruct(filename);
        String content = null;
        ArrayList<String> encodings = new ArrayList<String>();
        boolean encodingState = true;
        for (i = parts.size() - 1; i >= 0; --i) {
            String part;
            block6: {
                block5: {
                    part = parts.get(i);
                    if (!encodingState) break block5;
                    if (this.isEncoding.test(part)) break block6;
                    encodingState = false;
                }
                if (this.isContent.test(part)) {
                    content = part;
                    break;
                }
                ++i;
                break;
            }
            encodings.add(part);
        }
        String baseName = FileNameUtils.construct(parts.subList(0, i));
        Collections.reverse(encodings);
        FileNameImpl result = new FileNameImpl(baseName, content, encodings);
        return result;
    }

    public static void main(String[] args) {
        HashSet knownEncodings = Sets.newHashSet((Object[])new String[]{"gz", "bz2"});
        HashSet knownContentTypes = Sets.newHashSet((Object[])new String[]{"rdf", "xml", "ttl"});
        FileNameParser parser = FileNameParser.of(knownEncodings::contains, knownContentTypes::contains);
        FileName fileName = parser.parse("foo.rdf.gz");
        System.out.println(fileName.getBaseName());
        System.out.println(fileName.getContentPart());
        System.out.println(fileName.getEncodingParts());
    }
}

