/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.commons.util.string;

import java.util.Optional;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class Envsubst {
    public static final Pattern PLACEHOLDER_PATTERN = Pattern.compile("\\$(\\{(?<name1>[^}]*)\\}|(?<name2>[a-zA-Z_]\\w*))");

    public static String envsubst(String input, Function<String, String> getReplacement) {
        StringBuilder sb = new StringBuilder();
        Matcher m = PLACEHOLDER_PATTERN.matcher(input);
        while (m.find()) {
            String placeholderName = Optional.ofNullable(m.group("name1")).orElse(m.group("name2"));
            String replacement = getReplacement.apply(placeholderName);
            if (replacement == null) {
                m.appendReplacement(sb, "$0");
                continue;
            }
            m.appendReplacement(sb, "");
            sb.append(replacement);
        }
        m.appendTail(sb);
        return sb.toString();
    }
}

