/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.commons.util.retry;

import java.util.concurrent.Callable;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RetryUtils {
    private static final Logger logger = LoggerFactory.getLogger(RetryUtils.class);

    public static <T> T simpleRetry(long retryCount, long delayInMs, Callable<T> action) {
        T result = null;
        for (long retryAttempt = 0L; retryAttempt < retryCount; ++retryAttempt) {
            try {
                result = action.call();
                logger.trace(String.format("Retry attempt %d/%d succeeded", retryAttempt, retryCount));
                break;
            }
            catch (Exception e) {
                if (logger.isDebugEnabled()) {
                    logger.debug("Retry failed: " + ExceptionUtils.getRootCauseMessage((Throwable)e));
                }
                if (logger.isTraceEnabled()) {
                    logger.trace(String.format("Retry attempt %d/%d failed: ", retryAttempt + 1L, retryCount) + ExceptionUtils.getRootCauseMessage((Throwable)e), (Throwable)e);
                }
                if (retryAttempt + 1L == retryCount) {
                    throw new RuntimeException(e);
                }
                try {
                    Thread.sleep(delayInMs);
                    continue;
                }
                catch (Exception e2) {
                    throw new RuntimeException(e2);
                }
            }
        }
        return result;
    }
}

