/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.commons.util.obj;

import java.util.Arrays;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BinaryOperator;
import java.util.function.Supplier;
import org.apache.commons.lang3.ClassUtils;

public class ObjectUtils {
    public static Class<?> getClass(Object object) {
        return object == null ? null : object.getClass();
    }

    public static String toStringWithIdentityHashCode(Object obj) {
        return ObjectUtils.toStringWithIdentityHashCode(obj, "(null)");
    }

    public static String toStringWithIdentityHashCode(Object obj, String nullDefault) {
        return obj != null ? obj.getClass().getName() + "@" + System.identityHashCode(obj) : nullDefault;
    }

    public static boolean canCastAs(Class<?> clazz, Object o) {
        boolean result = o == null ? true : ClassUtils.isAssignable(o.getClass(), clazz);
        return result;
    }

    public static <T> Optional<T> tryCastAs(Class<T> clazz, Object o) {
        boolean canCastAs = ObjectUtils.canCastAs(clazz, o);
        Optional result = canCastAs ? Optional.of(ObjectUtils.castAs(clazz, o)) : Optional.empty();
        return result;
    }

    public static <T> T castAs(Class<T> clazz, Object o) {
        Object result = o;
        return (T)result;
    }

    public static <T> T castAsOrNull(Class<T> clazz, Object o) {
        T result = ObjectUtils.canCastAs(clazz, o) ? (T)ObjectUtils.castAs(clazz, o) : null;
        return result;
    }

    public static <T> T mergeNonNull(T a, T b, BinaryOperator<T> merger) {
        T result = a == null ? b : (b == null ? a : merger.apply(a, b));
        return result;
    }

    public static <T> T mergeNonNull(T a, T b, BinaryOperator<T> combiner, Supplier<T> nullCase) {
        T result = a == null ? (b == null ? nullCase.get() : b) : (b == null ? a : combiner.apply(a, b));
        return result;
    }

    @SafeVarargs
    public static <T> T coalesce(Supplier<T> ... ts) {
        return Arrays.asList(ts).stream().map(t -> t.get()).filter(t -> t != null).findFirst().orElse(null);
    }

    public static <T> T requireNullOrEqual(T a, T b) {
        boolean isInconsistent;
        boolean bl = isInconsistent = a != null && b != null && !Objects.equals(a, b);
        if (isInconsistent) {
            throw new IllegalArgumentException(String.format("Arguments %s and %s must both be equal or one must be null", a, b));
        }
        T result = a == null ? b : a;
        return result;
    }
}

