/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.commons.util.healthcheck;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.Callable;
import java.util.concurrent.TimeUnit;
import java.util.function.Predicate;
import java.util.function.Supplier;
import org.aksw.commons.util.function.ThrowingRunnable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HealthcheckRunner<T>
implements Callable<T>,
Runnable {
    private static final Logger logger = LoggerFactory.getLogger(HealthcheckRunner.class);
    protected long retryCount;
    protected long interval;
    protected TimeUnit intervalTimeUnit;
    protected Callable<? extends T> action;
    protected List<Predicate<? super Throwable>> fatalConditions;
    protected List<Supplier<Boolean>> continuationConditions;
    protected boolean isAborted;
    protected volatile Thread thread;

    public HealthcheckRunner(long retryCount, long interval, TimeUnit intervalTimeUnit, Callable<? extends T> action, List<Predicate<? super Throwable>> fatalConditions, List<Supplier<Boolean>> continuationConditions) {
        this.retryCount = retryCount;
        this.interval = interval;
        this.intervalTimeUnit = intervalTimeUnit;
        this.action = action;
        this.fatalConditions = fatalConditions;
        this.continuationConditions = continuationConditions;
    }

    public static Builder<Void> builder() {
        return new Builder<Void>();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void abort() {
        HealthcheckRunner healthcheckRunner = this;
        synchronized (healthcheckRunner) {
            if (this.thread != null) {
                this.thread.interrupt();
            }
            this.isAborted = true;
        }
    }

    public boolean isAborted() {
        return this.isAborted;
    }

    public boolean isConditionallyAborted() {
        boolean result = this.continuationConditions.stream().anyMatch(c -> Boolean.FALSE.equals(c.get()));
        return result;
    }

    @Override
    public void run() {
        this.call();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public T call() {
        HealthcheckRunner healthcheckRunner = this;
        synchronized (healthcheckRunner) {
            if (this.thread != null) {
                throw new IllegalStateException("run() was already called");
            }
            this.thread = Thread.currentThread();
        }
        T result = null;
        boolean success = false;
        Exception mostRecentException = null;
        int i = 0;
        boolean wasManuallyAborted = false;
        boolean wasConditionallyAborted = false;
        while (!((long)i >= this.retryCount || (wasManuallyAborted = this.isAborted()) || (wasConditionallyAborted = this.isConditionallyAborted()) || Thread.interrupted())) {
            boolean isLastIteration = (long)(i + 1) >= this.retryCount;
            try {
                result = this.action.call();
                logger.info("Health check status: success");
                success = true;
                break;
            }
            catch (Exception e) {
                mostRecentException = e;
                boolean isFatal = this.fatalConditions.stream().anyMatch(fatal -> fatal.test(e));
                if (isFatal) {
                    logger.info("Health check status: Encountered fatal condition, aborting with exception", (Throwable)e);
                    throw new RuntimeException(e);
                }
                logger.info("Health check status: not ok - " + (String)(this.retryCount >= Long.MAX_VALUE ? "" : this.retryCount - (long)i + " retries remaining. ") + (String)(isLastIteration ? "" : "Retrying in " + this.interval + " " + String.valueOf((Object)this.intervalTimeUnit)));
                if (!isLastIteration) {
                    try {
                        this.intervalTimeUnit.sleep(this.interval);
                    }
                    catch (InterruptedException e2) {
                        throw new RuntimeException("aborted", e2);
                    }
                }
                ++i;
            }
        }
        if (!success) {
            if (wasManuallyAborted) {
                throw new RuntimeException("Aborted up after " + i + " failed health checks", mostRecentException);
            }
            if (wasConditionallyAborted) {
                throw new RuntimeException("Aborted due to a condition not satisfied up after " + i + " failed health checks", mostRecentException);
            }
            throw new RuntimeException("Giving up after " + i + " failed health checks", mostRecentException);
        }
        return result;
    }

    public static class Builder<X> {
        protected long retryCount;
        protected long interval;
        protected TimeUnit intervalTimeUnit;
        protected Callable<X> action;
        protected List<Predicate<? super Throwable>> fatalConditions;
        protected List<Supplier<Boolean>> continuationConditions;

        public Builder() {
            this(60L, 1L, TimeUnit.SECONDS, null);
        }

        public Builder(long retryCount, long interval, TimeUnit intervalUnit, Callable<X> action) {
            this.retryCount = retryCount;
            this.interval = interval;
            this.intervalTimeUnit = intervalUnit;
            this.action = action;
            this.fatalConditions = null;
            this.continuationConditions = null;
        }

        public long getRetryCount() {
            return this.retryCount;
        }

        public Builder<X> setRetryCount(long retryCount) {
            this.retryCount = retryCount;
            return this;
        }

        public long getInterval() {
            return this.interval;
        }

        public Builder<X> setInterval(long interval, TimeUnit timeUnit) {
            Objects.requireNonNull(timeUnit, "TimeUnit must not be null");
            this.interval = interval;
            this.intervalTimeUnit = timeUnit;
            return this;
        }

        public TimeUnit getIntervalTimeUnit() {
            return this.intervalTimeUnit;
        }

        public Callable<X> getAction() {
            return this.action;
        }

        public <Y> Builder<Y> setAction(Callable<Y> action) {
            Builder view = this;
            view.action = action;
            return view;
        }

        public Builder<Void> setAction(ThrowingRunnable action) {
            Callable<Void> callable = () -> {
                action.run();
                return null;
            };
            return this.setAction(callable);
        }

        public List<Predicate<? super Throwable>> getFatalConditions() {
            return this.fatalConditions;
        }

        public Builder<X> addFatalCondition(Predicate<? super Throwable> fatalCondition) {
            if (this.fatalConditions == null) {
                this.fatalConditions = new ArrayList<Predicate<? super Throwable>>(1);
            }
            this.fatalConditions.add(fatalCondition);
            return this;
        }

        public Builder<X> addContinuationCondition(Supplier<Boolean> continuationCondition) {
            if (this.continuationConditions == null) {
                this.continuationConditions = new ArrayList<Supplier<Boolean>>(1);
            }
            this.continuationConditions.add(continuationCondition);
            return this;
        }

        public HealthcheckRunner<X> build() {
            Objects.requireNonNull(this.action);
            return new HealthcheckRunner<X>(this.retryCount, this.interval, this.intervalTimeUnit, this.action, this.fatalConditions == null ? Collections.emptyList() : this.fatalConditions, this.continuationConditions == null ? Collections.emptyList() : this.continuationConditions);
        }
    }
}

