/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.commons.util.concurrent;

import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

public class ExecutorServiceUtils {
    public static ExecutorService newBlockingThreadPoolExecutor() {
        int numThreads = Runtime.getRuntime().availableProcessors() * 2;
        int queueSize = numThreads * 10;
        return ExecutorServiceUtils.newBlockingThreadPoolExecutor(numThreads, queueSize);
    }

    public static ExecutorService newBlockingThreadPoolExecutor(int threads, int queueSize) {
        ThreadPoolExecutor result = new ThreadPoolExecutor(threads, threads, 0L, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>(queueSize), new RejectedExecutionHandler(){

            @Override
            public void rejectedExecution(Runnable r, ThreadPoolExecutor executor) {
                try {
                    executor.getQueue().put(r);
                }
                catch (InterruptedException e) {
                    throw new RuntimeException(e);
                }
            }
        });
        return result;
    }
}

