/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.commons.util.concurrent;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.concurrent.RejectedExecutionException;
import org.aksw.commons.util.concurrent.CompletableFutureDelegate;

public class CompletionTracker
implements Executor {
    protected Executor executor;
    protected volatile long counter = 0L;
    protected Map<Long, CompletableFuture<?>> pending = new HashMap();
    protected volatile boolean isShutDown = false;
    protected List<Throwable> raisedExceptions = Collections.synchronizedList(new ArrayList());

    public CompletionTracker(Executor executor) {
        this.executor = executor;
    }

    public static CompletionTracker from(Executor executor) {
        return new CompletionTracker(executor);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdown() {
        CompletionTracker completionTracker = this;
        synchronized (completionTracker) {
            this.isShutDown = true;
            this.checkTerminationCondition();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void execute(Runnable runnable) {
        CompletableFutureDelegate exposedFuture;
        long id;
        CompletionTracker completionTracker = this;
        synchronized (completionTracker) {
            if (this.isShutDown) {
                throw new RejectedExecutionException("New task rejected because completionTracker was already shut down");
            }
            id = this.counter++;
            exposedFuture = new CompletableFutureDelegate();
            this.pending.put(id, exposedFuture);
        }
        CompletableFuture<Void> internalFuture = CompletableFuture.runAsync(runnable, this.executor);
        exposedFuture.setDelegate(internalFuture);
        internalFuture.whenComplete((value, throwable) -> {
            LinkedHashMap cancelMap = null;
            CompletionTracker completionTracker = this;
            synchronized (completionTracker) {
                this.pending.remove(id);
                this.checkTerminationCondition();
                if (throwable != null) {
                    this.raisedExceptions.add((Throwable)throwable);
                    this.shutdown();
                    cancelMap = new LinkedHashMap(this.pending);
                }
            }
            if (throwable != null) {
                cancelMap.values().forEach(future -> future.cancel(true));
                exposedFuture.completeExceptionally((Throwable)throwable);
            } else {
                exposedFuture.complete(value);
            }
        });
    }

    protected boolean isTerminated() {
        boolean result = this.isShutDown && this.pending.isEmpty();
        return result;
    }

    protected void checkTerminationCondition() {
        if (this.isTerminated()) {
            this.notifyAll();
        }
    }

    public List<Throwable> getRaisedExceptions() {
        return this.raisedExceptions;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void awaitTermination() throws InterruptedException {
        CompletionTracker completionTracker = this;
        synchronized (completionTracker) {
            while (!this.isTerminated()) {
                this.wait();
            }
        }
        if (!this.raisedExceptions.isEmpty()) {
            throw new RuntimeException(this.raisedExceptions.get(0));
        }
    }
}

