/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.commons.util.closeable;

import org.aksw.commons.util.stack_trace.StackTraceUtils;

public class AutoCloseableBase
implements AutoCloseable {
    protected volatile boolean isClosed = false;
    protected boolean enableCloseStackTrace;
    protected StackTraceElement[] closeStackTrace = null;

    public AutoCloseableBase() {
        this(true);
    }

    public AutoCloseableBase(boolean enableCloseStackTrace) {
        this.enableCloseStackTrace = enableCloseStackTrace;
    }

    protected void ensureOpen() {
        if (this.isClosed) {
            String str = StackTraceUtils.toString(this.closeStackTrace);
            this.throwClosedException("Object already closed at: " + str);
        }
    }

    protected void throwClosedException(String msg) {
        throw new RuntimeException(msg);
    }

    protected void closeActual() throws Exception {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void close() {
        if (!this.isClosed) {
            AutoCloseableBase autoCloseableBase = this;
            synchronized (autoCloseableBase) {
                if (!this.isClosed) {
                    this.closeStackTrace = this.enableCloseStackTrace ? StackTraceUtils.getStackTraceIfEnabled() : null;
                    try {
                        this.closeActual();
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                    finally {
                        this.isClosed = true;
                    }
                }
            }
        }
    }
}

