/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.commons.util.algebra;

import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import com.google.common.collect.Sets;
import com.google.common.collect.Streams;
import com.google.common.graph.SuccessorsFunction;
import com.google.common.graph.Traverser;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.aksw.commons.util.algebra.ExprFilter;
import org.aksw.commons.util.algebra.ExprOps;
import org.aksw.commons.util.algebra.GenericFactorizer;

public class GenericDag<E, V> {
    protected ExprOps<E, V> exprOps;
    protected ExprFilter<E> isBlocker;
    protected GenericFactorizer<E, V> exprFactorizer;
    protected Supplier<V> nextVar;
    protected BiMap<V, E> varToExpr = HashBiMap.create();
    protected Set<E> roots = new LinkedHashSet();

    public GenericDag(ExprOps<E, V> exprOps, Supplier<V> nextVar, ExprFilter<E> isBlocker) {
        this.exprOps = exprOps;
        this.isBlocker = isBlocker;
        this.exprFactorizer = new GenericFactorizer<E, V>(exprOps, isBlocker);
        this.nextVar = nextVar;
    }

    public GenericDag<E, V> subDag(Collection<E> roots) {
        GenericDag<E, V> result = new GenericDag<E, V>(this.exprOps, this.nextVar, this.isBlocker);
        result.getRoots().addAll(roots);
        ExprOps<E, V> exprOps = this.getExprOps();
        SuccessorsFunction<E> successors = GenericDag.createSuccessorFunction(this);
        Streams.stream((Iterable)Traverser.forTree(successors).depthFirstPostOrder(roots)).forEach(expr -> {
            V v = this.getVar(expr);
            if (v != null) {
                result.getVarToExpr().put(v, expr);
            }
        });
        return result;
    }

    public GenericDag<E, V> applyVarTransform(Function<V, V> remap) {
        GenericDag<E, V> result = new GenericDag<E, V>(this.exprOps, this.nextVar, this.isBlocker);
        Function<Object, Object> exprRemap = e -> this.exprOps.isVar(e) ? Optional.ofNullable(remap.apply(this.exprOps.asVar(e))).map(this.exprOps::varToExpr).orElse(e) : e;
        this.varToExpr.forEach((v, e) -> {
            Object newV = Objects.requireNonNullElse(remap.apply(v), v);
            Object newE = ExprOps.replace(this.exprOps, e, exprRemap);
            result.varToExpr.put(newV, newE);
        });
        this.roots.forEach(e -> {
            Object newE = ExprOps.replace(this.exprOps, e, exprRemap);
            result.roots.add(newE);
        });
        return result;
    }

    public GenericDag<E, V> cloneObject() {
        GenericDag<E, V> result = new GenericDag<E, V>(this.exprOps, this.nextVar, this.isBlocker);
        result.varToExpr.putAll(this.varToExpr);
        result.roots.addAll(this.roots);
        return result;
    }

    public ExprOps<E, V> getExprOps() {
        return this.exprFactorizer.getExprOps();
    }

    public E factorize(E expr) {
        E result = this.exprFactorizer.factorize(expr, this.varToExpr, this.nextVar);
        return result;
    }

    public E addRoot(E expr) {
        E newRoot = this.factorize(expr);
        this.roots.add(newRoot);
        return newRoot;
    }

    public GenericFactorizer<E, V> getExprFactorizer() {
        return this.exprFactorizer;
    }

    public BiMap<V, E> getVarToExpr() {
        return this.varToExpr;
    }

    public Set<E> getRoots() {
        return this.roots;
    }

    public E getExpr(V var) {
        Object result = this.varToExpr.get(var);
        return (E)result;
    }

    public V getVar(E expr) {
        Object result = this.varToExpr.inverse().get(expr);
        return (V)result;
    }

    public E remove(V var) {
        return (E)this.varToExpr.remove(var);
    }

    public Multimap<V, V> getChildToParent() {
        HashMultimap result = HashMultimap.create();
        for (Map.Entry e : this.varToExpr.entrySet()) {
            Object parent = e.getKey();
            List<E> exprs = this.exprOps.getSubExprs(e.getValue());
            for (E expr : exprs) {
                if (!this.exprOps.isVar(expr)) continue;
                V child = this.exprOps.asVar(expr);
                result.put(child, parent);
            }
        }
        return result;
    }

    public Set<V> getVarsWithMultipleParents() {
        LinkedHashSet result = new LinkedHashSet();
        Map map = this.getChildToParent().asMap();
        for (Map.Entry entry : map.entrySet()) {
            if (((Collection)entry.getValue()).size() <= 1) continue;
            result.add(entry.getKey());
        }
        return result;
    }

    public void collapse() {
        Multimap<V, V> mm = this.getChildToParent();
        for (E root : this.roots) {
            this.collapse(root, mm);
        }
    }

    protected void collapse(E expr, Multimap<V, V> mm) {
        V exprVar;
        E exprDef;
        if (this.exprOps.isVar(expr) && (exprDef = this.getExpr(exprVar = this.exprOps.asVar(expr))) != null) {
            Set<V> subExprVars = this.exprOps.varsMentioned(exprDef);
            for (V subExprVar : subExprVars) {
                E subExprDef = this.exprOps.varToExpr(subExprVar);
                if (subExprDef == null) continue;
                this.collapse(subExprDef, mm);
            }
            Object newDef = ExprOps.replace(this.exprOps, exprDef, ev -> {
                Object r = null;
                if (this.exprOps.isVar(ev)) {
                    V v = this.exprOps.asVar(ev);
                    if (!this.roots.contains(ev) && mm.get(v).size() == 1) {
                        r = this.getExpr(v);
                        this.remove(v);
                    }
                }
                if (r == null) {
                    r = ev;
                }
                return r;
            });
            this.remove(exprVar);
            this.varToExpr.put(exprVar, newDef);
        }
    }

    public static <E, V> E expand(GenericDag<E, V> dag, E root) {
        ExprOps exprOps = dag.getExprOps();
        Object result = ExprOps.replace(dag.getExprOps(), root, e -> {
            Object var;
            Object def;
            Object r = e;
            if (exprOps.isVar(e) && (def = dag.getExpr(var = exprOps.asVar(e))) != null) {
                r = GenericDag.expand(dag, def);
            }
            return r;
        });
        return (E)result;
    }

    public static <E, V> Map<V, E> getSortedDependencies(GenericDag<E, V> dag) {
        return GenericDag.getSortedDependencies(dag, dag.getRoots());
    }

    public static <E, V> Map<V, E> getSortedDependencies(GenericDag<E, V> dag, Collection<E> roots) {
        ExprOps<E, V> exprOps = dag.getExprOps();
        LinkedHashMap result = new LinkedHashMap();
        for (E root : roots) {
            GenericDag.getSortedDependencies(dag, root, result);
            if (!exprOps.isVar(root)) continue;
            V rootVar = exprOps.asVar(root);
            if (result.keySet().contains(rootVar)) continue;
            result.put(rootVar, null);
        }
        return result;
    }

    public static <E, V> void getSortedDependencies(GenericDag<E, V> dag, E node, Map<V, E> acc) {
        ExprOps<E, V> exprOps = dag.getExprOps();
        Set<V> varsMentioned = exprOps.varsMentioned(node);
        for (V var : varsMentioned) {
            E def = dag.getExpr(var);
            if (def == null) continue;
            GenericDag.getSortedDependencies(dag, def, acc);
            if (acc.containsKey(var)) continue;
            acc.put(var, def);
        }
    }

    public static <E, V> Set<V> getUndefinedVars(GenericDag<E, V> dag) {
        return GenericDag.getUndefinedVars(dag, dag.getRoots());
    }

    public static <E, V> Set<V> getUndefinedVars(GenericDag<E, V> dag, Collection<E> roots) {
        ExprOps<E, V> exprOps = dag.getExprOps();
        SuccessorsFunction<E> successors = GenericDag.createSuccessorFunction(dag);
        Set result = Streams.stream((Iterable)Traverser.forTree(successors).depthFirstPostOrder(roots)).filter(exprOps::isVar).map(exprOps::asVar).filter(v -> dag.getExpr(v) == null).collect(Collectors.toCollection(LinkedHashSet::new));
        return result;
    }

    public static <E, V> Set<E> getCoreDefinitions(GenericDag<E, V> dag) {
        return GenericDag.getCoreDefinitions(dag, dag.getRoots());
    }

    public static <E, V> Set<E> getCoreDefinitions(GenericDag<E, V> dag, Collection<E> roots) {
        ExprOps exprOps = dag.getExprOps();
        Set undefVars = GenericDag.getUndefinedVars(dag, roots);
        SuccessorsFunction<E> successors = GenericDag.createSuccessorFunction(dag);
        Set result = Streams.stream((Iterable)Traverser.forTree(successors).depthFirstPostOrder(roots)).filter(expr -> {
            Set mentionedVars = exprOps.varsMentioned(expr);
            boolean r = !Sets.intersection((Set)undefVars, mentionedVars).isEmpty();
            Object v = dag.getVar(expr);
            if (v == null) {
                r = false;
            }
            return r;
        }).collect(Collectors.toCollection(LinkedHashSet::new));
        return result;
    }

    public static <E, V> SuccessorsFunction<E> createSuccessorFunction(GenericDag<E, V> dag) {
        ExprOps exprOps = dag.getExprOps();
        return e -> {
            Object var;
            Object def;
            List<Object> r = exprOps.isVar(e) ? ((def = dag.getExpr(var = exprOps.asVar(e))) != null ? Collections.singletonList(def) : Collections.emptyList()) : exprOps.getSubExprs(e);
            return r;
        };
    }

    public static <E, V> void depthFirstTraverse(GenericDag<E, V> dag, E parent, int childIdx, E child, ExprFilter<E> isBlocked, Consumer<E> visitor) {
        if (!isBlocked.test(parent, childIdx, child)) {
            ExprOps<E, V> exprOps = dag.getExprOps();
            if (exprOps.isVar(child)) {
                V var = exprOps.asVar(child);
                E def = dag.getExpr(var);
                if (def != null) {
                    GenericDag.depthFirstTraverse(dag, child, 0, def, isBlocked, visitor);
                } else {
                    visitor.accept(child);
                }
            } else {
                List<E> subExprs = exprOps.getSubExprs(child);
                for (int i = 0; i < subExprs.size(); ++i) {
                    E subExpr = subExprs.get(i);
                    GenericDag.depthFirstTraverse(dag, child, i, subExpr, isBlocked, visitor);
                }
                visitor.accept(child);
            }
        }
    }
}

