/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.commons.util.range;

import com.google.common.collect.Range;
import com.google.common.collect.RangeMap;
import com.google.common.collect.Streams;
import com.google.common.collect.TreeRangeMap;
import com.google.common.collect.TreeRangeSet;
import com.google.common.graph.Traverser;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.stream.Stream;

public class RangeTreeNode<K extends Comparable<K>, V> {
    protected Range<K> nodeRange;
    protected Collection<V> values;
    protected RangeMap<K, RangeTreeNode<K, V>> children = TreeRangeMap.create();

    public static <K extends Comparable<K>, V> RangeTreeNode<K, V> newRoot() {
        return new RangeTreeNode<K, V>(Range.all());
    }

    public Collection<V> getValues() {
        return this.values;
    }

    public RangeTreeNode(Range<K> nodeRange) {
        this(nodeRange, Collections.emptySet());
    }

    public RangeTreeNode(Range<K> nodeRange, V value) {
        this(nodeRange, (Collection<V>)Collections.singleton(value));
    }

    public RangeTreeNode(Range<K> nodeRange, Collection<V> values) {
        this.nodeRange = nodeRange;
        this.values = new LinkedHashSet<V>(values);
    }

    public RangeMap<K, RangeTreeNode<K, V>> getChildren() {
        return this.children;
    }

    public Collection<RangeTreeNode<K, V>> getChildNodes() {
        return this.getChildren().asMapOfRanges().values();
    }

    public Stream<V> streamAllValuesPreOrder() {
        return Streams.stream((Iterable)Traverser.forTree(node -> node.getChildNodes()).depthFirstPreOrder((Object)this)).flatMap(node -> node.getValues().stream());
    }

    public void put(Range<K> insertRange, V value) {
        RangeTreeNode<K, V> newNode;
        Map childMap = this.children.asMapOfRanges();
        boolean processed = false;
        if (insertRange.equals(this.nodeRange)) {
            this.values.add(value);
            processed = true;
        }
        TreeRangeSet overlappingChildren = null;
        if (!processed) {
            for (Map.Entry child : childMap.entrySet()) {
                Range childRange = (Range)child.getKey();
                if (childRange.encloses(insertRange)) {
                    ((RangeTreeNode)child.getValue()).put(insertRange, value);
                    processed = true;
                    break;
                }
                if (!childRange.isConnected(insertRange) || childRange.intersection(insertRange).isEmpty()) continue;
                if (overlappingChildren == null) {
                    overlappingChildren = TreeRangeSet.create();
                }
                overlappingChildren.add(childRange);
            }
        }
        if (!processed && overlappingChildren != null) {
            processed = true;
            newNode = new RangeTreeNode<K, V>(insertRange, value);
            for (Range overlap : overlappingChildren.asRanges()) {
                RangeTreeNode node = (RangeTreeNode)childMap.remove(overlap);
                newNode.children.put(node.nodeRange, (Object)node);
            }
            this.children.put(insertRange, newNode);
        }
        if (!processed) {
            newNode = new RangeTreeNode<K, V>(insertRange, value);
            this.children.put(insertRange, newNode);
            processed = true;
        }
    }

    public String toString() {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        this.print(new PrintStream((OutputStream)baos, true, StandardCharsets.UTF_8), "");
        return baos.toString();
    }

    public void print(PrintStream out, String indent) {
        out.println(indent + "span: " + String.valueOf(this.nodeRange));
        out.println(indent + "|- values: " + String.valueOf(this.values));
        int i = 0;
        Iterator it = this.children.asMapOfRanges().entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry entry = it.next();
            out.println(indent + "|- child[" + i + "]");
            String nextIndent = it.hasNext() ? "|  " : "   ";
            ((RangeTreeNode)entry.getValue()).print(out, indent + nextIndent);
            ++i;
        }
    }

    public static void main(String[] args) {
        RangeTreeNode root = RangeTreeNode.newRoot();
        root.put(Range.closedOpen((Comparable)Integer.valueOf(0), (Comparable)Integer.valueOf(5)), "a");
        root.put(Range.closedOpen((Comparable)Integer.valueOf(1), (Comparable)Integer.valueOf(4)), "b");
        root.put(Range.closedOpen((Comparable)Integer.valueOf(2), (Comparable)Integer.valueOf(6)), "c");
        root.put(Range.closedOpen((Comparable)Integer.valueOf(10), (Comparable)Integer.valueOf(20)), "d");
        root.put(Range.closedOpen((Comparable)Integer.valueOf(0), (Comparable)Integer.valueOf(100)), "e");
        root.put(Range.all(), "f");
        System.out.println(root);
    }
}

