/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.commons.util.page;

import java.util.ArrayList;
import java.util.List;
import org.aksw.commons.util.page.Paginator;

public abstract class PaginatorBase<T>
implements Paginator<T> {
    protected long itemsPerPage = 10L;
    protected long showProximity = 4L;
    protected long visiblePages;

    public PaginatorBase(long itemsPerPage) {
        this.itemsPerPage = itemsPerPage;
    }

    @Override
    public List<T> createPages(long numItems, long itemOffset) {
        long numPages = numItems / this.itemsPerPage + Math.min(numItems % this.itemsPerPage, 1L);
        long activePage = itemOffset / this.itemsPerPage;
        long halfProximity = this.showProximity / 2L;
        long extraSpace = this.showProximity % 2L;
        long showBefore = halfProximity + extraSpace;
        long showAfter = halfProximity;
        long availBefore = activePage;
        long availAfter = numPages - activePage - 1L;
        long beforeToAfter = Math.max(showBefore - availBefore, 0L);
        long afterToBefore = Math.max((showAfter += beforeToAfter) - availAfter, 0L);
        showBefore += afterToBefore;
        showBefore = Math.min(showBefore, availBefore);
        showAfter = Math.min(showAfter, availAfter);
        long from = activePage - showBefore;
        long to = activePage + showAfter;
        ArrayList<T> result = new ArrayList<T>();
        for (long i = from; i <= to; ++i) {
            long pageStart = i * this.itemsPerPage;
            long pageEnd = Math.min(pageStart + this.itemsPerPage, numItems);
            boolean isActive = itemOffset >= pageStart && itemOffset < pageEnd;
            T page = this.createPage(i, pageStart, pageEnd, isActive);
            result.add(page);
        }
        return result;
    }

    protected abstract T createPage(long var1, long var3, long var5, boolean var7);
}

