/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.commons.util.obj;

import com.google.common.collect.ClassToInstanceMap;
import com.google.common.collect.MutableClassToInstanceMap;
import java.util.Objects;
import java.util.function.Supplier;

public class Enriched<T> {
    protected T item;
    protected ClassToInstanceMap<Object> classToInstanceMap;

    public Enriched(T item) {
        this(item, (ClassToInstanceMap<Object>)MutableClassToInstanceMap.create());
    }

    public Enriched(T item, ClassToInstanceMap<Object> classToInstanceMap) {
        this.item = item;
        this.classToInstanceMap = classToInstanceMap;
    }

    public T getItem() {
        return this.item;
    }

    public ClassToInstanceMap<Object> getClassToInstanceMap() {
        return this.classToInstanceMap;
    }

    public <X> X getInstance(Class<X> type) {
        return (X)this.classToInstanceMap.getInstance(type);
    }

    public <X> X getInstanceOrDefault(Class<X> type, X defaultValue) {
        Object result = this.classToInstanceMap.getInstance(type);
        if (result == null) {
            result = defaultValue;
        }
        return (X)result;
    }

    public <X> X putInstance(X value) {
        Class<?> type = value.getClass();
        this.classToInstanceMap.put(type, value);
        return value;
    }

    public <X> X putInstance(Class<X> type, X value) {
        return (X)this.classToInstanceMap.putInstance(type, value);
    }

    public <X> X getOrCreateInstance(Class<X> type, Supplier<X> ctor) {
        Object result = this.classToInstanceMap.getInstance(type);
        if (result == null) {
            result = ctor.get();
            this.classToInstanceMap.putInstance(type, result);
        }
        return (X)result;
    }

    public static <T> Enriched<T> of(T item) {
        return new Enriched<T>(item);
    }

    public static <T> Enriched<T> of(T item, Object value) {
        Enriched<T> result = Enriched.of(item);
        if (value != null) {
            result.getClassToInstanceMap().put(value.getClass(), value);
        }
        return result;
    }

    public int hashCode() {
        return Objects.hash(this.item, this.classToInstanceMap);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Enriched other = (Enriched)obj;
        return Objects.equals(this.item, other.item) && Objects.equals(this.classToInstanceMap, other.classToInstanceMap);
    }

    public String toString() {
        return "Enriched [item=" + String.valueOf(this.item) + ", classToInstanceMap=" + String.valueOf(this.classToInstanceMap) + "]";
    }
}

