/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.commons.util.memoize;

import java.util.Collections;
import java.util.Map;
import java.util.function.Supplier;
import org.aksw.commons.util.memoize.MemoizedSupplier;

public class MemoizedSupplierImpl<T>
implements MemoizedSupplier<T> {
    protected Supplier<T> supplier;
    protected Map<Void, T> cache;

    public MemoizedSupplierImpl(Supplier<T> supplier) {
        this.supplier = supplier;
        this.cache = Collections.emptyMap();
    }

    public static <T> MemoizedSupplier<T> of(Supplier<T> supplier) {
        return new MemoizedSupplierImpl<T>(supplier);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public T get() {
        if (this.cache.isEmpty()) {
            MemoizedSupplierImpl memoizedSupplierImpl = this;
            synchronized (memoizedSupplierImpl) {
                if (this.cache.isEmpty()) {
                    T value = this.supplier.get();
                    this.cache = Collections.singletonMap(null, value);
                }
            }
        }
        return this.cache.values().iterator().next();
    }

    @Override
    public Map<Void, T> getCache() {
        return this.cache;
    }

    @Override
    public void clearCache() {
        this.cache = Collections.emptyMap();
    }
}

