/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.commons.util.lifecycle;

import org.aksw.commons.util.lifecycle.LifeCycle;

public abstract class LifeCycleBase
implements LifeCycle {
    protected State state = State.NEW;

    protected void expectStarted() {
        if (!State.STARTED.equals((Object)this.state)) {
            throw new IllegalStateException("expected state to be STARTED; was: " + String.valueOf((Object)this.state));
        }
    }

    @Override
    public final void start() {
        if (!State.NEW.equals((Object)this.state)) {
            throw new IllegalStateException("start() may only be called once when in state NEW; was: " + String.valueOf((Object)this.state));
        }
        this.state = State.STARTED;
        this.startActual();
    }

    @Override
    public final void finish() {
        if (!State.STARTED.equals((Object)this.state)) {
            throw new IllegalStateException("finish() may only be called once when in state STARTED; was" + String.valueOf((Object)this.state));
        }
        this.state = State.FINISHED;
        this.finishActual();
    }

    protected abstract void startActual();

    protected abstract void finishActual();

    public static enum State {
        NEW,
        STARTED,
        FINISHED;

    }
}

