/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.commons.util.jdbc;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.aksw.commons.util.jdbc.Column;
import org.aksw.commons.util.jdbc.ColumnsReference;
import org.aksw.commons.util.jdbc.DatabaseObject;
import org.aksw.commons.util.jdbc.ForeignKey;
import org.aksw.commons.util.jdbc.Index;
import org.aksw.commons.util.jdbc.PrimaryKey;
import org.aksw.commons.util.jdbc.Relation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JdbcUtils {
    private static final Logger logger = LoggerFactory.getLogger(JdbcUtils.class);

    public static Multimap<String, ForeignKey> fetchForeignKeys(Connection conn) throws SQLException {
        DatabaseMetaData meta = conn.getMetaData();
        String catalog = conn.getCatalog();
        Multimap<String, ForeignKey> result = JdbcUtils.fetchForeignKeys(meta, catalog);
        return result;
    }

    public static Multimap<String, ForeignKey> fetchForeignKeys(DatabaseMetaData meta, String catalog) throws SQLException {
        Multimap<String, ForeignKey> result = JdbcUtils.fetchForeignKeys(meta, catalog, null, (String)null);
        return result;
    }

    public static Multimap<String, ForeignKey> fetchForeignKeys(DatabaseMetaData meta, String catalog, String schema, Iterable<String> tables) throws SQLException {
        HashMultimap result = HashMultimap.create();
        if (tables == null) {
            tables = Collections.singleton(null);
        }
        for (String table : tables) {
            Multimap<String, ForeignKey> tmp = JdbcUtils.fetchForeignKeys(meta, catalog, schema, table);
            result.putAll(tmp);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Multimap<String, ForeignKey> fetchForeignKeys(DatabaseMetaData meta, String catalog, String schema, String table) throws SQLException {
        ResultSet rs;
        HashMultimap result = HashMultimap.create();
        logger.debug("Fetching foreign keys of table " + table + " in schema " + schema);
        try {
            rs = meta.getExportedKeys(catalog, schema, table);
        }
        catch (Exception e) {
            logger.warn("getExportedKeys threw an exception - assuming absence of foreign keys", (Throwable)e);
            return result;
        }
        try {
            HashMap<String, ForeignKey> fkNameMap = new HashMap<String, ForeignKey>();
            while (rs.next()) {
                String fkName = rs.getString("FK_NAME");
                String fkTableName = rs.getString("FKTABLE_NAME");
                String fkColumnName = rs.getString("FKCOLUMN_NAME");
                String pkTableName = rs.getString("PKTABLE_NAME");
                String pkColumnName = rs.getString("PKCOLUMN_NAME");
                ForeignKey current = (ForeignKey)fkNameMap.get(fkName);
                if (current == null) {
                    current = new ForeignKey(fkName, new ColumnsReference(fkTableName, new String[0]), new ColumnsReference(pkTableName, new String[0]));
                    fkNameMap.put(fkName, current);
                }
                current.getSource().getColumnNames().add(fkColumnName);
                current.getTarget().getColumnNames().add(pkColumnName);
            }
            for (ForeignKey fk : fkNameMap.values()) {
                result.put((Object)fk.getSource().getTableName(), (Object)fk);
            }
        }
        finally {
            rs.close();
        }
        return result;
    }

    public static Map<String, PrimaryKey> fetchPrimaryKeys(Connection conn) throws SQLException {
        DatabaseMetaData meta = conn.getMetaData();
        String catalog = conn.getCatalog();
        Map<String, PrimaryKey> result = JdbcUtils.fetchPrimaryKeys(meta, catalog);
        return result;
    }

    public static Map<String, PrimaryKey> fetchPrimaryKeys(DatabaseMetaData meta, String catalog) throws SQLException {
        Map<String, PrimaryKey> result = JdbcUtils.fetchPrimaryKeys(meta, catalog, null, (String)null);
        return result;
    }

    public static Map<String, PrimaryKey> fetchPrimaryKeys(DatabaseMetaData meta, String catalog, String schema, Iterable<String> tables) throws SQLException {
        HashMap<String, PrimaryKey> result = new HashMap<String, PrimaryKey>();
        if (tables == null) {
            tables = Collections.singleton(null);
        }
        for (String table : tables) {
            Map<String, PrimaryKey> tmp = JdbcUtils.fetchPrimaryKeys(meta, catalog, schema, table);
            result.putAll(tmp);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Map<String, PrimaryKey> fetchPrimaryKeys(DatabaseMetaData meta, String catalog, String schema, String table) throws SQLException {
        HashMap<String, PrimaryKey> result = new HashMap<String, PrimaryKey>();
        if (table == null) {
            table = "%";
        }
        try (ResultSet rs = meta.getPrimaryKeys(catalog, schema, table);){
            PrimaryKey current = null;
            while (rs.next()) {
                String tableName = rs.getString("TABLE_NAME");
                String columnName = rs.getString("COLUMN_NAME");
                String pkName = rs.getString("PK_NAME");
                if (current == null || !tableName.equals(current.getSource().getTableName())) {
                    current = new PrimaryKey(pkName, new ColumnsReference(tableName, new String[0]));
                    result.put(tableName, current);
                }
                current.getSource().getColumnNames().add(columnName);
            }
        }
        return result;
    }

    public static Set<String> fetchRelationNames(Connection conn) throws SQLException {
        DatabaseMetaData meta = conn.getMetaData();
        String catalog = conn.getCatalog();
        Set<String> result = JdbcUtils.fetchRelationNames(meta, catalog);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Set<String> fetchRelationNames(DatabaseMetaData meta, String catalog) throws SQLException {
        String[] types = new String[]{"TABLE", "VIEW"};
        TreeSet<String> result = new TreeSet<String>();
        try (ResultSet rs = meta.getTables(catalog, null, null, types);){
            while (rs.next()) {
                result.add(rs.getString("TABLE_NAME"));
            }
        }
        return result;
    }

    public static Map<String, Relation> fetchColumns(Connection conn) throws SQLException {
        DatabaseMetaData meta = conn.getMetaData();
        String catalog = conn.getCatalog();
        Map<String, Relation> result = JdbcUtils.fetchColumns(meta, catalog, null, (String)null);
        return result;
    }

    public static Map<String, Relation> fetchColumns(Connection conn, String schema, String table) throws SQLException {
        DatabaseMetaData meta = conn.getMetaData();
        String catalog = conn.getCatalog();
        Map<String, Relation> result = JdbcUtils.fetchColumns(meta, catalog, schema, table);
        return result;
    }

    public static Map<String, Relation> fetchColumns(DatabaseMetaData meta, String catalog) throws SQLException {
        Map<String, Relation> result = JdbcUtils.fetchColumns(meta, catalog, null, (String)null);
        return result;
    }

    public static Map<String, Relation> fetchColumns(DatabaseMetaData meta, String catalog, String schema, Iterable<String> tables) throws SQLException {
        HashMap<String, Relation> result = new HashMap<String, Relation>();
        if (tables == null) {
            tables = Collections.singleton(null);
        }
        for (String table : tables) {
            Map<String, Relation> tmp = JdbcUtils.fetchColumns(meta, catalog, schema, table);
            result.putAll(tmp);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Map<String, Relation> fetchColumns(DatabaseMetaData meta, String catalog, String schema, String table) throws SQLException {
        HashMap<String, Relation> result = new HashMap<String, Relation>();
        try (ResultSet rs = meta.getColumns(catalog, schema, table, null);){
            DatabaseObject current = null;
            while (rs.next()) {
                String tableName = rs.getString("TABLE_NAME");
                String columnName = rs.getString("COLUMN_NAME");
                String typeName = rs.getString("TYPE_NAME");
                String rawIsNullable = rs.getString("IS_NULLABLE");
                int ordinalPosition = rs.getInt("ORDINAL_POSITION");
                Boolean isNullable = null;
                if ("YES".equalsIgnoreCase(rawIsNullable)) {
                    isNullable = true;
                } else if ("NO".equalsIgnoreCase(rawIsNullable)) {
                    isNullable = false;
                }
                if (current == null || !tableName.equals(current.getName())) {
                    current = new Relation(tableName);
                    result.put(tableName, (Relation)current);
                }
                Column column = new Column(ordinalPosition, columnName, typeName, isNullable);
                ((Relation)current).getColumns().put(columnName, column);
            }
        }
        return result;
    }

    public static Multimap<String, Index> fetchIndexes(DatabaseMetaData meta, String catalog, String schemaName, Iterable<String> tableNames, boolean unique) throws SQLException {
        HashMultimap result = HashMultimap.create();
        if (tableNames == null) {
            tableNames = Collections.singleton(null);
        }
        for (String tableName : tableNames) {
            Multimap<String, Index> tmp = JdbcUtils.fetchIndexes(meta, catalog, null, tableName, unique);
            result.putAll(tmp);
        }
        return result;
    }

    public static Multimap<String, Index> fetchIndexes(DatabaseMetaData meta, String catalog, String schemaName, String tableName, boolean unique) throws SQLException {
        ArrayListMultimap result;
        try {
            result = JdbcUtils.fetchIndexesUnsafe(meta, catalog, schemaName, tableName, unique);
        }
        catch (Exception e) {
            logger.warn("Failed to retrieve indexes", (Throwable)e);
            result = ArrayListMultimap.create();
        }
        return result;
    }

    public static Multimap<String, Index> fetchIndexesUnsafe(DatabaseMetaData meta, String catalog, String schemaName, String tableName, boolean unique) throws SQLException {
        ArrayListMultimap result = ArrayListMultimap.create();
        ResultSet rs = meta.getIndexInfo(catalog, schemaName, tableName, unique, false);
        DatabaseObject current = null;
        while (rs.next()) {
            String indexName = rs.getString("INDEX_NAME");
            String table = rs.getString("TABLE_NAME");
            String columnName = rs.getString("COLUMN_NAME");
            boolean isNonUnique = rs.getBoolean("NON_UNIQUE");
            if (indexName == null) continue;
            if (current == null || !indexName.equals(current.getName())) {
                current = new Index(tableName, table, !isNonUnique);
                result.put((Object)tableName, (Object)current);
            }
            ((Index)current).getColumns().getColumnNames().add(columnName);
        }
        return result;
    }
}

