/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.commons.util.algebra;

import com.google.common.collect.BiMap;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import org.aksw.commons.util.algebra.ExprFilter;
import org.aksw.commons.util.algebra.ExprOps;

public class GenericFactorizer<E, V> {
    protected ExprOps<E, V> exprOps;
    protected ExprFilter<E> isBlocker;

    public GenericFactorizer(ExprOps<E, V> exprOps, ExprFilter<E> isBlocker) {
        this.exprOps = exprOps;
        this.isBlocker = isBlocker;
    }

    public ExprOps<E, V> getExprOps() {
        return this.exprOps;
    }

    public ExprFilter<E> getIsBlocker() {
        return this.isBlocker;
    }

    public E factorize(E expr, BiMap<V, E> varCxt, Supplier<V> nextVar) {
        E result = this.factorize(null, 0, expr, varCxt, nextVar);
        return result;
    }

    public E factorize(E parent, int childIdx, E child, BiMap<V, E> cxt, Supplier<V> nextVar) {
        E result;
        if (this.isBlocker != null && this.isBlocker.test(parent, childIdx, child)) {
            result = child;
        } else {
            List<E> before = this.exprOps.getSubExprs(child);
            ArrayList<E> after = new ArrayList<E>(before.size());
            for (int i = 0; i < before.size(); ++i) {
                E subExpr = before.get(i);
                E tmp = this.factorize(child, i, subExpr, cxt, nextVar);
                after.add(tmp);
            }
            E e = this.exprOps.copy(child, after);
            if (this.exprOps.isFunction(e)) {
                Object var = cxt.inverse().get(e);
                if (var == null) {
                    var = nextVar.get();
                    cxt.put(var, e);
                }
                result = this.exprOps.varToExpr(var);
            } else {
                result = e;
            }
        }
        return result;
    }
}

