/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.commons.util.time;

import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import java.time.Duration;
import java.time.temporal.ChronoUnit;
import java.util.AbstractMap;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.function.BiFunction;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class TimeAgo {
    public static final List<Long> times = Arrays.asList(TimeUnit.DAYS.toMillis(365L), TimeUnit.DAYS.toMillis(30L), TimeUnit.DAYS.toMillis(1L), TimeUnit.HOURS.toMillis(1L), TimeUnit.MINUTES.toMillis(1L), TimeUnit.SECONDS.toMillis(1L));
    public static final List<ChronoUnit> timesString = Arrays.asList(ChronoUnit.YEARS, ChronoUnit.MONTHS, ChronoUnit.DAYS, ChronoUnit.HOURS, ChronoUnit.MINUTES, ChronoUnit.SECONDS);
    public static final BiMap<String, ChronoUnit> suffixToUnit = HashBiMap.create();
    public static final Pattern parsePattern;

    public static Duration parse(String string) {
        Matcher matcher = parsePattern.matcher(string);
        Duration result = Duration.ZERO;
        while (matcher.find()) {
            String numberStr = matcher.group(1);
            String unitStr = matcher.group(3);
            Double number = Double.parseDouble(numberStr);
            ChronoUnit chronoUnit = unitStr.isBlank() ? ChronoUnit.SECONDS : (ChronoUnit)suffixToUnit.get((Object)unitStr);
            TimeUnit timeUnit = TimeUnit.of(chronoUnit);
            long factor = TimeUnit.NANOSECONDS.convert(1L, timeUnit);
            long nanos = Math.multiplyExact(number.longValue(), factor);
            Duration contrib = Duration.of(nanos, ChronoUnit.NANOS);
            result = result == null ? contrib : result.plus(contrib);
        }
        return result;
    }

    public static String fmtLong(long value, ChronoUnit chronoUnit) {
        return String.valueOf(value == 0L ? "moments" : Long.valueOf(value)) + " " + chronoUnit.toString().toLowerCase() + " ago";
    }

    public static String fmtCompact(long value, ChronoUnit chronoUnit) {
        String suffix = (String)suffixToUnit.inverse().get((Object)chronoUnit);
        if (suffix == null) {
            suffix = "(unknown time unit)";
        }
        return value == 0L ? "now" : Long.toString(value) + suffix;
    }

    public static String toDuration(long duration, BiFunction<Long, ChronoUnit, String> formatter) {
        Map.Entry<Long, ChronoUnit> pair = TimeAgo.toDuration(duration);
        String result = formatter.apply(pair.getKey(), pair.getValue());
        return result;
    }

    public static Map.Entry<Long, ChronoUnit> toDuration(long duration) {
        long value = 0L;
        ChronoUnit unit = null;
        for (int i = 0; i < times.size(); ++i) {
            Long current = times.get(i);
            long temp = duration / current;
            if (temp <= 0L) continue;
            value = temp;
            unit = timesString.get(i);
            break;
        }
        if (unit == null) {
            unit = ChronoUnit.SECONDS;
        }
        return new AbstractMap.SimpleEntry<Long, ChronoUnit>(value, unit);
    }

    public static void main(String[] args) {
        Locale.setDefault(Locale.GERMAN);
        System.out.println(TimeAgo.parse("5m5m"));
        BiFunction<Long, ChronoUnit, String> labelizer = TimeAgo::fmtCompact;
        System.out.println(TimeAgo.toDuration(123L, labelizer));
        System.out.println(TimeAgo.toDuration(1230L, labelizer));
        System.out.println(TimeAgo.toDuration(12300L, labelizer));
        System.out.println(TimeAgo.toDuration(123000L, labelizer));
        System.out.println(TimeAgo.toDuration(1230000L, labelizer));
        System.out.println(TimeAgo.toDuration(12300000L, labelizer));
        System.out.println(TimeAgo.toDuration(123000000L, labelizer));
        System.out.println(TimeAgo.toDuration(1230000000L, labelizer));
        System.out.println(TimeAgo.toDuration(12300000000L, labelizer));
        System.out.println(TimeAgo.toDuration(123000000000L, labelizer));
    }

    static {
        suffixToUnit.put((Object)"ns", (Object)ChronoUnit.NANOS);
        suffixToUnit.put((Object)"ms", (Object)ChronoUnit.MILLIS);
        suffixToUnit.put((Object)"s", (Object)ChronoUnit.SECONDS);
        suffixToUnit.put((Object)"m", (Object)ChronoUnit.MINUTES);
        suffixToUnit.put((Object)"h", (Object)ChronoUnit.HOURS);
        suffixToUnit.put((Object)"d", (Object)ChronoUnit.DAYS);
        suffixToUnit.put((Object)"M", (Object)ChronoUnit.MONTHS);
        suffixToUnit.put((Object)"y", (Object)ChronoUnit.YEARS);
        parsePattern = Pattern.compile("(\\d+(\\.\\d*)?)([^\\d]*)");
    }
}

