/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.commons.util.string;

import com.google.common.collect.Iterables;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.aksw.commons.util.string.FileName;
import org.aksw.commons.util.string.FileNameUtils;

public class FileNameImpl
implements FileName {
    protected String baseName;
    protected String contentPart;
    protected List<String> encodingParts;

    public FileNameImpl(String baseName, String contentPart, List<String> encodingParts) {
        this.baseName = baseName;
        this.contentPart = contentPart;
        this.encodingParts = encodingParts;
    }

    public static FileName create(String baseName, String contentPart, List<String> encodingParts) {
        return new FileNameImpl(baseName, contentPart, encodingParts);
    }

    @Override
    public String getBaseName() {
        return this.baseName;
    }

    @Override
    public String getContentPart() {
        return this.contentPart;
    }

    @Override
    public List<String> getEncodingParts() {
        return this.encodingParts;
    }

    @Override
    public String getExtension(boolean precedeWithDotIfNotEmpty) {
        String result = FileNameUtils.construct(Iterables.concat(Collections.singletonList(this.contentPart), this.encodingParts));
        result = precedeWithDotIfNotEmpty && !result.isEmpty() ? "." + result : result;
        return result;
    }

    public String toString() {
        String result = FileNameUtils.construct(Iterables.concat(Arrays.asList(this.baseName, this.contentPart), this.encodingParts));
        return result;
    }
}

