/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.commons.util.stream;

import com.google.common.collect.AbstractIterator;
import com.google.common.collect.Iterators;
import java.util.AbstractMap;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Spliterator;
import java.util.Spliterators;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.aksw.commons.util.stream.CollapseRunsOperationBase;
import org.aksw.commons.util.stream.CollapseRunsSpec;

public class StreamOperatorCollapseRuns<T, K, V>
extends CollapseRunsOperationBase<T, K, V> {
    public static <T, K, V> StreamOperatorCollapseRuns<T, K, V> create(CollapseRunsSpec<T, K, V> spec) {
        return new StreamOperatorCollapseRuns<T, K, V>(spec);
    }

    public StreamOperatorCollapseRuns(CollapseRunsSpec<T, K, V> other) {
        super(other);
    }

    public Iterator<Map.Entry<K, V>> transform(Iterator<T> input) {
        return new OperatorImpl(input).getDownstream();
    }

    public Stream<Map.Entry<K, V>> transform(Stream<T> input) {
        return (Stream)StreamSupport.stream(this.transform(input.spliterator()), input.isParallel()).onClose(input::close);
    }

    public Spliterator<Map.Entry<K, V>> transform(Spliterator<T> upstream) {
        return new SpliteratorImpl(upstream);
    }

    public static <T> void split(Spliterator<T> root, Consumer<? super Spliterator<T>> action) {
        Spliterator<T> rhs = root;
        Spliterator<T> lhs = root.trySplit();
        if (lhs != null) {
            System.out.println("LHS");
            action.accept(lhs);
        } else {
            System.out.println("LHS (null)");
        }
        System.out.println("RHS");
        action.accept(rhs);
    }

    public static <T> void print(Spliterator<T> root) {
        Iterator<T> it = Spliterators.iterator(root);
        it.forEachRemaining(System.out::println);
    }

    public static void main(String[] args) {
        StreamOperatorCollapseRuns<Integer, Integer, Integer> op = StreamOperatorCollapseRuns.create(CollapseRunsSpec.createAcc(i -> i, () -> 0, (acc, item) -> acc + 1));
        List<Integer> ints = Arrays.asList(1, 2, 2, 3, 3, 3, 4, 4, 4, 4, 1, 2, 3, 4);
        int[] counter = new int[]{0};
        StreamOperatorCollapseRuns<Integer, Integer, int[]> op2 = StreamOperatorCollapseRuns.create(CollapseRunsSpec.create(i -> i, () -> {
            counter[0] = 0;
            return counter;
        }, (acc, item) -> {
            acc[0] = acc[0] + 1;
        }));
        op2.transform(ints.stream()).forEach(e -> System.out.println("Static Agg: " + String.valueOf(e.getKey()) + ": " + ((int[])e.getValue())[0]));
        Spliterator<Map.Entry<Integer, Integer>> derived = op.transform(ints.spliterator());
        StreamOperatorCollapseRuns.split(derived, x -> StreamOperatorCollapseRuns.split(x, y -> StreamOperatorCollapseRuns.split(y, StreamOperatorCollapseRuns::print)));
        Stream s = ints.stream();
        List actual = op.transform(s).collect(Collectors.toList());
        List<Map.Entry> expected = Arrays.asList(new AbstractMap.SimpleEntry<Integer, Integer>(1, 1), new AbstractMap.SimpleEntry<Integer, Integer>(2, 2), new AbstractMap.SimpleEntry<Integer, Integer>(3, 3), new AbstractMap.SimpleEntry<Integer, Integer>(4, 4), new AbstractMap.SimpleEntry<Integer, Integer>(1, 1), new AbstractMap.SimpleEntry<Integer, Integer>(2, 1), new AbstractMap.SimpleEntry<Integer, Integer>(3, 1), new AbstractMap.SimpleEntry<Integer, Integer>(4, 1));
        System.out.println(expected);
        System.out.println(actual);
    }

    public class OperatorImpl
    extends CollapseRunsOperationBase.AccumulatorBase {
        protected Iterator<T> upstream;
        protected Iterator<Map.Entry<K, V>> downstream;
        protected T item;
        protected boolean hasPendingGroup;
        protected K pendingGroupKey;

        public T getLastSeenItem() {
            return this.item;
        }

        public OperatorImpl(Iterator<T> upstream) {
            super(StreamOperatorCollapseRuns.this);
            this.hasPendingGroup = false;
            this.pendingGroupKey = null;
            this.upstream = upstream;
            this.downstream = new InternalIterator();
        }

        public Iterator<Map.Entry<K, V>> getDownstream() {
            return this.downstream;
        }

        public class InternalIterator
        extends AbstractIterator<Map.Entry<K, V>> {
            protected Map.Entry<K, V> computeNext() {
                AbstractMap.SimpleEntry<Object, Object> result = null;
                if (OperatorImpl.this.hasPendingGroup) {
                    OperatorImpl.this.priorKey = OperatorImpl.this.currentKey;
                    OperatorImpl.this.currentKey = OperatorImpl.this.pendingGroupKey;
                    OperatorImpl.this.currentAcc = StreamOperatorCollapseRuns.this.accCtor.apply(OperatorImpl.this.accNum, OperatorImpl.this.pendingGroupKey);
                    ++OperatorImpl.this.accNum;
                    if (OperatorImpl.this.currentAcc != null) {
                        OperatorImpl.this.currentAcc = StreamOperatorCollapseRuns.this.accAdd.apply(OperatorImpl.this.currentAcc, OperatorImpl.this.item);
                    }
                    OperatorImpl.this.hasPendingGroup = false;
                }
                while (OperatorImpl.this.upstream.hasNext()) {
                    OperatorImpl.this.item = OperatorImpl.this.upstream.next();
                    OperatorImpl.this.currentKey = StreamOperatorCollapseRuns.this.getGroupKey.apply(OperatorImpl.this.item);
                    if (OperatorImpl.this.accNum == 0L) {
                        OperatorImpl.this.priorKey = OperatorImpl.this.currentKey;
                        OperatorImpl.this.currentAcc = StreamOperatorCollapseRuns.this.accCtor.apply(OperatorImpl.this.accNum, OperatorImpl.this.currentKey);
                        ++OperatorImpl.this.accNum;
                    } else if (!StreamOperatorCollapseRuns.this.groupKeyCompare.test(OperatorImpl.this.priorKey, OperatorImpl.this.currentKey)) {
                        result = new AbstractMap.SimpleEntry<Object, Object>(OperatorImpl.this.priorKey, OperatorImpl.this.currentAcc);
                        OperatorImpl.this.pendingGroupKey = OperatorImpl.this.currentKey;
                        OperatorImpl.this.hasPendingGroup = true;
                        break;
                    }
                    if (OperatorImpl.this.currentAcc == null) continue;
                    OperatorImpl.this.currentAcc = StreamOperatorCollapseRuns.this.accAdd.apply(OperatorImpl.this.currentAcc, OperatorImpl.this.item);
                }
                if (result == null) {
                    if (OperatorImpl.this.accNum != 0L && !OperatorImpl.this.lastItemSent) {
                        result = new AbstractMap.SimpleEntry<Object, Object>(OperatorImpl.this.currentKey, OperatorImpl.this.currentAcc);
                        OperatorImpl.this.lastItemSent = true;
                    } else {
                        result = (AbstractMap.SimpleEntry<Object, Object>)this.endOfData();
                    }
                }
                return result;
            }
        }
    }

    public class SpliteratorImpl
    extends Spliterators.AbstractSpliterator<Map.Entry<K, V>> {
        protected StreamOperatorCollapseRuns<T, K, List<T>> listAggregator;
        protected Iterator<T> headItem;
        protected Spliterator<T> upstream;
        protected Iterator<T> tailItems;
        protected Iterator<T> iteratorView;
        protected Iterator<Map.Entry<K, V>> aggIteratorView;

        protected SpliteratorImpl(Spliterator<T> upstream) {
            this(Collections.emptyList().iterator(), upstream, Collections.emptyList().iterator());
        }

        protected SpliteratorImpl(Iterator<T> headItem, Spliterator<T> upstream, Iterator<T> tailItems) {
            super(upstream.estimateSize(), 16);
            this.listAggregator = StreamOperatorCollapseRuns.create(CollapseRunsSpec.createList(StreamOperatorCollapseRuns.this.getGroupKey));
            this.headItem = headItem;
            this.upstream = upstream;
            this.tailItems = tailItems;
            this.updateIteratorViews();
        }

        protected void updateIteratorViews() {
            this.iteratorView = Iterators.concat(this.headItem, Spliterators.iterator(this.upstream), this.tailItems);
            this.aggIteratorView = new OperatorImpl(this.iteratorView).getDownstream();
        }

        @Override
        public Spliterator<Map.Entry<K, V>> trySplit() {
            SpliteratorImpl result;
            Spliterator lhsSplit = this.upstream.trySplit();
            Spliterator rhsSplit = this.upstream;
            if (lhsSplit != null) {
                Iterator rhsTailItems;
                Iterator rhsHeadItem;
                Iterator rhsIt = Spliterators.iterator(rhsSplit);
                Iterator rhsItPlusTail = Iterators.concat(rhsIt, this.tailItems);
                StreamOperatorCollapseRuns streamOperatorCollapseRuns = this.listAggregator;
                Objects.requireNonNull(streamOperatorCollapseRuns);
                OperatorImpl op = streamOperatorCollapseRuns.new OperatorImpl(rhsItPlusTail);
                Iterator rhsItPlusTailIt = op.getDownstream();
                List lhsTailItems = Collections.emptyList();
                if (rhsItPlusTailIt.hasNext()) {
                    lhsTailItems = (List)rhsItPlusTailIt.next().getValue();
                }
                if (op.lastItemSent) {
                    rhsHeadItem = Collections.emptyList().iterator();
                    rhsTailItems = Collections.emptyList().iterator();
                } else {
                    rhsHeadItem = Collections.singletonList(op.getLastSeenItem()).iterator();
                    rhsTailItems = this.tailItems;
                }
                Iterator lhsHeadItem = this.headItem;
                this.headItem = rhsHeadItem;
                this.upstream = rhsSplit;
                this.tailItems = rhsTailItems;
                this.updateIteratorViews();
                result = new SpliteratorImpl(lhsHeadItem, lhsSplit, lhsTailItems.iterator());
            } else {
                result = null;
            }
            return result;
        }

        @Override
        public boolean tryAdvance(Consumer<? super Map.Entry<K, V>> action) {
            boolean result = this.aggIteratorView.hasNext();
            if (result) {
                Map.Entry entry = this.aggIteratorView.next();
                action.accept(entry);
            }
            return result;
        }
    }
}

