/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.commons.util.ref;

import java.util.Map;
import java.util.WeakHashMap;
import java.util.function.Consumer;
import org.aksw.commons.util.ref.Ref;
import org.aksw.commons.util.stack_trace.StackTraceUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RefImpl<T>
implements Ref<T> {
    private static final Logger logger = LoggerFactory.getLogger(RefImpl.class);
    protected boolean traceAcquisitions = true;
    protected T value;
    protected AutoCloseable releaseAction;
    protected Object synchronizer;
    protected Object comment;
    protected RefImpl<T> parent;
    protected volatile boolean isClosed = false;
    protected StackTraceElement[] acquisitionStackTrace;
    protected StackTraceElement[] closeStackTrace;
    protected StackTraceElement[] closeTriggerStackTrace;
    protected Map<Ref<T>, Object> childRefs = new WeakHashMap<Ref<T>, Object>();
    protected volatile int activeChildRefs = 0;

    public RefImpl(RefImpl<T> parent, T value, Object synchronizer, AutoCloseable releaseAction, Object comment) {
        this.parent = parent;
        this.value = value;
        this.releaseAction = releaseAction;
        this.synchronizer = synchronizer == null ? this : synchronizer;
        this.comment = comment;
        if (this.traceAcquisitions) {
            this.acquisitionStackTrace = StackTraceUtils.getStackTraceIfEnabled();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void finalize() throws Throwable {
        block7: {
            try {
                if (this.isClosed) break block7;
                Object object = this.synchronizer;
                synchronized (object) {
                    if (!this.isClosed) {
                        String msg = "Ref released by GC rather than user logic - indicates resource leak.Acquired at " + StackTraceUtils.toString(this.acquisitionStackTrace);
                        logger.warn(msg);
                        this.close();
                    }
                }
            }
            finally {
                super.finalize();
            }
        }
    }

    public Object getComment() {
        return this.comment;
    }

    @Override
    public Object getSynchronizer() {
        return this.synchronizer;
    }

    @Override
    public T get() {
        if (this.isClosed) {
            String msg = "Cannot get value of a closed reference:\nAcquired at " + StackTraceUtils.toString(this.acquisitionStackTrace) + "\nClosed at " + StackTraceUtils.toString(this.closeStackTrace) + "\nClose Triggered at " + StackTraceUtils.toString(this.closeTriggerStackTrace);
            logger.warn(msg);
            throw new RuntimeException("Cannot get value of a closed reference");
        }
        return this.value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Ref<T> acquire(Object comment) {
        Object object = this.synchronizer;
        synchronized (object) {
            Ref[] tmp;
            if (!this.isAlive()) {
                String msg = "Cannot acquire from a reference with status 'isAlive=false'\nClose triggered at: " + StackTraceUtils.toString(this.closeTriggerStackTrace);
                throw new RuntimeException(msg);
            }
            tmp = new Ref[]{new RefImpl<T>(this, this.value, this.synchronizer, () -> this.release(tmp[0]), comment)};
            Ref result = tmp[0];
            this.childRefs.put(result, comment);
            ++this.activeChildRefs;
            return result;
        }
    }

    protected void release(Object childRef) {
        boolean isContained = this.childRefs.containsKey(childRef);
        if (!isContained) {
            throw new RuntimeException("An unknown reference requested to release itself. Should not happen");
        }
        this.childRefs.remove(childRef);
        --this.activeChildRefs;
        this.checkRelease();
    }

    @Override
    public boolean isAlive() {
        boolean result = !this.isClosed || this.activeChildRefs != 0;
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        Object object = this.synchronizer;
        synchronized (object) {
            if (this.isClosed) {
                String msg = "Reference was already closed.\nReleased at: " + StackTraceUtils.toString(this.closeStackTrace) + "\nAcquired at: " + StackTraceUtils.toString(this.acquisitionStackTrace) + "\nTriggered at " + StackTraceUtils.toString(this.closeTriggerStackTrace);
                throw new RuntimeException(msg);
            }
            if (this.traceAcquisitions) {
                this.closeStackTrace = StackTraceUtils.getStackTraceIfEnabled();
            }
            this.isClosed = true;
            this.checkRelease();
        }
    }

    protected void checkRelease() {
        if (!this.isAlive()) {
            if (this.traceAcquisitions) {
                this.closeTriggerStackTrace = StackTraceUtils.getStackTraceIfEnabled();
            }
            if (this.releaseAction != null) {
                try {
                    this.releaseAction.close();
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
        }
    }

    public static <T extends AutoCloseable> Ref<T> fromCloseable(T value, Object synchronizer) {
        return RefImpl.create(value, synchronizer, value);
    }

    public static <T> Ref<T> create2(T value, Object synchronizer, Consumer<? super T> closer) {
        return RefImpl.create(value, synchronizer, () -> closer.accept((Object)value), null);
    }

    public static <T> Ref<T> create(T value, Object synchronizer, AutoCloseable releaseAction) {
        return RefImpl.create(value, synchronizer, releaseAction, null);
    }

    public static <T> Ref<T> create(T value, Object synchronizer, AutoCloseable releaseAction, Object comment) {
        return new RefImpl<T>(null, value, synchronizer, releaseAction, comment);
    }

    public static <T> Ref<T> createClosed() {
        RefImpl<Object> result = new RefImpl<Object>(null, null, null, null, null);
        result.isClosed = true;
        return result;
    }

    @Override
    public boolean isClosed() {
        return this.isClosed;
    }

    @Override
    public Ref<T> getRootRef() {
        RefImpl<T> result = this;
        while (result.parent != null) {
            result = result.parent;
        }
        return result;
    }

    @Override
    public StackTraceElement[] getAcquisitionStackTrace() {
        return this.acquisitionStackTrace;
    }

    @Override
    public StackTraceElement[] getCloseStackTrace() {
        return this.closeStackTrace;
    }

    @Override
    public StackTraceElement[] getCloseTriggerStackTrace() {
        return this.closeTriggerStackTrace;
    }

    public String toString() {
        String result = String.format("Ref %s, active(self, #children)=(%b, %d), aquired at %s", this.comment, !this.isClosed, this.activeChildRefs, StackTraceUtils.toString(this.acquisitionStackTrace));
        return result;
    }
}

