/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.commons.util.lifecycle;

import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.FileSystem;
import java.nio.file.FileSystemNotFoundException;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicBoolean;
import org.aksw.commons.util.exception.FinallyRunAll;
import org.aksw.commons.util.function.ThrowingRunnable;

public class ResourceMgr
implements AutoCloseable {
    private final Map<Object, ThrowingRunnable> resourceToCloser = Collections.synchronizedMap(new IdentityHashMap());
    private AtomicBoolean isClosed = new AtomicBoolean(false);

    public <T extends AutoCloseable> T register(T closable) {
        return (T)this.register(closable, AutoCloseable::close);
    }

    public <T> T register(T obj, FinallyRunAll.ThrowingConsumer<? super T> closer) {
        return this.register(obj, () -> closer.accept((Object)obj));
    }

    public <T> T register(T obj, ThrowingRunnable closeAction) {
        if (this.isClosed.get()) {
            try {
                closeAction.run();
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        } else {
            this.resourceToCloser.put(obj, closeAction);
        }
        return obj;
    }

    @Override
    public void close() {
        if (!this.isClosed.get()) {
            FinallyRunAll.runAll(this.resourceToCloser.entrySet(), e -> ((ThrowingRunnable)e.getValue()).run(), null);
        }
    }

    public boolean isClosed() {
        return this.isClosed.get();
    }

    public static Path toPath(ResourceMgr resourceMgr, Class<?> clz, String classPath) throws IOException {
        URL url = clz.getResource(classPath);
        return ResourceMgr.toPath(resourceMgr, url);
    }

    public static Path toPath(ResourceMgr resourceMgr, URL url) throws IOException {
        Objects.requireNonNull(url);
        try {
            return ResourceMgr.toPath(resourceMgr, url.toURI());
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(e);
        }
    }

    public static Path toPath(ResourceMgr resourceMgr, URI uri) throws IOException {
        Path result;
        try {
            Path rawPath = Paths.get(uri);
            result = ResourceMgr.fixPath(rawPath);
        }
        catch (FileSystemNotFoundException ex) {
            FileSystem fs = FileSystems.newFileSystem(uri, Collections.emptyMap());
            resourceMgr.register(fs);
            result = fs.provider().getPath(uri);
        }
        return result;
    }

    public static Path fixPath(Path path) {
        Path result = path;
        Path parentPath = path.getParent();
        if (parentPath != null && !Files.exists(parentPath, new LinkOption[0])) {
            Path fixedCandidatePath = path.resolve("/modules").resolve(path.getRoot().relativize(path));
            result = Files.exists(fixedCandidatePath, new LinkOption[0]) ? fixedCandidatePath : path;
        }
        return result;
    }
}

