/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.commons.util.exception;

import java.net.UnknownHostException;
import java.nio.channels.ClosedChannelException;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Predicate;
import org.apache.commons.lang3.exception.ExceptionUtils;

public class ExceptionUtilsAksw {
    @SafeVarargs
    public static <T extends Throwable> void rethrowUnless(T t, Predicate<? super T> ... predicates) {
        boolean anyMatch = Arrays.asList(predicates).stream().anyMatch(p -> p.test(t));
        if (!anyMatch) {
            throw new RuntimeException(t);
        }
    }

    public static boolean isBrokenPipeException(Throwable t) {
        String str = ExceptionUtils.getRootCauseMessage((Throwable)t);
        boolean result = str != null && str.toLowerCase().contains("broken pipe");
        return result;
    }

    public static boolean isConnectionRefusedException(Throwable t) {
        Throwable rootCause = ExceptionUtils.getRootCause((Throwable)t);
        String str = ExceptionUtils.getMessage((Throwable)rootCause);
        boolean isClosedChannel = ExceptionUtilsAksw.isClosedChannelException(rootCause);
        boolean isConnectionRefused = str != null && str.toLowerCase().contains("connection refused");
        boolean result = isClosedChannel || isConnectionRefused;
        return result;
    }

    public static boolean isUnknownHostException(Throwable t) {
        boolean result = ExceptionUtilsAksw.isRootCauseInstanceOf(t, UnknownHostException.class);
        return result;
    }

    public static Predicate<Throwable> isRootCauseInstanceOf(Class<?> superClass) {
        return arg -> {
            boolean r = ExceptionUtilsAksw.isRootCauseInstanceOf(arg, superClass);
            return r;
        };
    }

    public static boolean isRootCauseInstanceOf(Throwable t, Class<?> superClass) {
        Throwable rootCause = ExceptionUtils.getRootCause((Throwable)t);
        boolean r = rootCause != null && superClass.isInstance(rootCause);
        return r;
    }

    public static void rethrowIfNotBrokenPipe(Throwable t) {
        ExceptionUtilsAksw.rethrowUnless(t, ExceptionUtilsAksw::isBrokenPipeException);
    }

    @SafeVarargs
    public static <T extends Throwable> void forwardRootCauseUnless(T t, Consumer<? super Throwable> handler, Predicate<? super T> ... predicates) {
        boolean anyMatch = Arrays.asList(predicates).stream().anyMatch(p -> p.test(t));
        if (!anyMatch) {
            Throwable rootCause = ExceptionUtils.getRootCause(t);
            handler.accept(rootCause);
        }
    }

    @SafeVarargs
    public static <T extends Throwable> void forwardRootCauseMessageUnless(T t, Consumer<? super String> handler, Predicate<? super T> ... predicates) {
        boolean anyMatch = Arrays.asList(predicates).stream().anyMatch(p -> p.test(t));
        if (!anyMatch) {
            String rootCauseMsg = ExceptionUtils.getRootCauseMessage(t);
            handler.accept(rootCauseMsg);
        }
    }

    @SafeVarargs
    public static Optional<Throwable> unwrap(Throwable given, Class<? extends Throwable> ... priorities) {
        Optional<Throwable> result = ExceptionUtilsAksw.unwrap(given, Arrays.asList(priorities));
        return result;
    }

    public static Optional<Throwable> unwrap(Throwable given, List<Class<? extends Throwable>> priorities) {
        Optional<Throwable> result = priorities.stream().map(priority -> ExceptionUtils.indexOfType((Throwable)given, (Class)priority)).filter(index -> index >= 0).map(ExceptionUtils.getThrowableList((Throwable)given)::get).findFirst();
        return result;
    }

    public static boolean isClosedChannelException(Throwable t) {
        boolean result = t instanceof ClosedChannelException;
        return result;
    }

    @SafeVarargs
    public static void rethrowUnlessRootCauseMatches(Throwable e, Consumer<? super Predicate<? super Throwable>> firstMatchingConditionCallback, Predicate<? super Throwable> ... conditions) {
        Throwable rootCause = ExceptionUtils.getRootCause((Throwable)e);
        Predicate match = Arrays.asList(conditions).stream().filter(p -> p.test(rootCause)).findFirst().orElse(null);
        if (match == null) {
            throw new RuntimeException(e);
        }
        firstMatchingConditionCallback.accept(match);
    }

    @SafeVarargs
    public static void rethrowUnlessRootCauseMatches(Throwable e, Predicate<? super Throwable> ... conditions) {
        ExceptionUtilsAksw.rethrowUnlessRootCauseMatches(e, (? super Predicate<? super Throwable> condition) -> {}, conditions);
    }
}

