/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.commons.util.concurrent;

import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Future;

public class CompletableFutureDelegate<T>
extends CompletableFuture<T> {
    protected Future<?> delegate;
    protected Boolean isCancelled = null;

    public CompletableFutureDelegate() {
        this(null);
    }

    public CompletableFutureDelegate(Future<?> delegate) {
        this.delegate = delegate;
    }

    public void setDelegate(Future<?> delegate) {
        if (this.delegate != null) {
            throw new IllegalStateException("Delegate has already been set");
        }
        this.delegate = delegate;
        if (this.isCancelled != null) {
            this.cancel(this.isCancelled);
        }
    }

    @Override
    public boolean cancel(boolean mayInterruptIfRunning) {
        boolean result;
        this.isCancelled = mayInterruptIfRunning;
        if (this.delegate != null) {
            result = this.delegate.cancel(mayInterruptIfRunning);
            super.cancel(mayInterruptIfRunning);
        } else {
            result = true;
        }
        return result;
    }
}

