/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.commons.util.closeable;

import org.aksw.commons.util.closeable.AutoCloseableBase;
import org.aksw.commons.util.stack_trace.StackTraceUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AutoCloseableWithLeakDetectionBase
extends AutoCloseableBase {
    private static final Logger logger = LoggerFactory.getLogger(AutoCloseableWithLeakDetectionBase.class);
    protected final StackTraceElement[] instantiationStackTrace;

    public AutoCloseableWithLeakDetectionBase() {
        this(true);
    }

    public AutoCloseableWithLeakDetectionBase(boolean enableInstantiationStackTrace) {
        super(enableInstantiationStackTrace);
        this.instantiationStackTrace = enableInstantiationStackTrace ? StackTraceUtils.getStackTraceIfEnabled() : null;
    }

    public StackTraceElement[] getInstantiationStackTrace() {
        return this.instantiationStackTrace;
    }

    protected void finalize() throws Throwable {
        try {
            if (!this.isClosed) {
                if (logger.isWarnEnabled()) {
                    String objectIdStr = ObjectUtils.identityToString((Object)this);
                    String stackTraceStr = StackTraceUtils.toString(this.instantiationStackTrace);
                    logger.warn(String.format("Close invoked via GC rather than user logic - indicates resource leak. Object %s constructed at %s", objectIdStr, stackTraceStr));
                }
                this.close();
            }
        }
        finally {
            super.finalize();
        }
    }
}

