/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.commons.util.cache;

import com.google.common.base.Converter;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheStats;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Streams;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ExecutionException;
import java.util.function.Predicate;
import java.util.stream.Collectors;

public class CacheView<KF, KB, V>
implements Cache<KF, V> {
    protected Cache<KB, V> backend;
    protected Converter<KF, KB> keyConverter;
    protected Predicate<KB> backendKeyFilter;

    public CacheView(Cache<KB, V> backend, Converter<KF, KB> keyConverter, Predicate<KB> backendFilter) {
        this.backend = backend;
        this.keyConverter = keyConverter;
        this.backendKeyFilter = backendFilter;
    }

    public Cache<KB, V> getBackend() {
        return this.backend;
    }

    protected KB safeToBackend(KF key) {
        Object result = this.keyConverter.convert(key);
        if (!this.backendKeyFilter.test(result)) {
            throw new IllegalStateException("Converted key was rejected by filter. Input: " + String.valueOf(key) + " Output: " + String.valueOf(result));
        }
        return (KB)result;
    }

    protected List<KB> convert(Object key) {
        Object in;
        Object tmp;
        try {
            in = tmp = key;
        }
        catch (ClassCastException e) {
            return Collections.emptyList();
        }
        tmp = this.safeToBackend(in);
        return Collections.singletonList(tmp);
    }

    public V getIfPresent(Object key) {
        Cache<KB, V> backend = this.getBackend();
        Object result = null;
        for (KB backendKey : this.convert(key)) {
            result = backend.getIfPresent(backendKey);
        }
        return (V)result;
    }

    public V get(KF key, Callable<? extends V> loader) throws ExecutionException {
        Cache<KB, V> backend = this.getBackend();
        Object backendKey = this.keyConverter.convert(key);
        Object result = backend.get(backendKey, loader);
        return (V)result;
    }

    public ImmutableMap<KF, V> getAllPresent(Iterable<? extends Object> keys) {
        Cache<KB, V> backend = this.getBackend();
        List backendKeys = Streams.stream(keys).map(k -> k).map(arg_0 -> this.keyConverter.convert(arg_0)).collect(Collectors.toList());
        ImmutableMap.Builder mapBuilder = ImmutableMap.builder();
        ImmutableMap tmp = backend.getAllPresent(backendKeys);
        tmp.forEach((backendKey, value) -> {
            Object frontendKey = this.keyConverter.reverse().convert(backendKey);
            mapBuilder.put(frontendKey, value);
        });
        ImmutableMap result = mapBuilder.build();
        return result;
    }

    public void put(KF key, V value) {
        Cache<KB, V> backend = this.getBackend();
        Object backendKey = this.keyConverter.convert(key);
        backend.put(backendKey, value);
    }

    public void putAll(Map<? extends KF, ? extends V> m) {
        Cache<KB, V> backend = this.getBackend();
        Map<Object, Object> map = m.entrySet().stream().collect(Collectors.toMap(e -> this.safeToBackend(e.getKey()), Map.Entry::getValue));
        backend.putAll(map);
    }

    public void invalidate(Object key) {
        Cache<KB, V> backend = this.getBackend();
        for (KB backendKey : this.convert(key)) {
            backend.invalidate(backendKey);
        }
    }

    public void invalidateAll(Iterable<? extends Object> keys) {
        Cache<KB, V> backend = this.getBackend();
        List backendKeys = Streams.stream(keys).flatMap(key -> this.convert(key).stream()).collect(Collectors.toList());
        backend.invalidateAll(backendKeys);
    }

    public void invalidateAll() {
        Cache<KB, V> backend = this.getBackend();
        Collection backendKeys = backend.asMap().keySet().stream().filter(this.backendKeyFilter).collect(Collectors.toList());
        backend.invalidateAll((Iterable)backendKeys);
    }

    public long size() {
        Cache<KB, V> backend = this.getBackend();
        long result = backend.asMap().keySet().stream().filter(this.backendKeyFilter).count();
        return result;
    }

    public CacheStats stats() {
        Cache<KB, V> backend = this.getBackend();
        CacheStats result = backend.stats();
        return result;
    }

    public ConcurrentMap<KF, V> asMap() {
        throw new UnsupportedOperationException();
    }

    public void cleanUp() {
        Cache<KB, V> backend = this.getBackend();
        backend.cleanUp();
    }
}

