/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.commons.util.benchmark;

import com.google.common.base.Stopwatch;
import java.time.Duration;
import java.util.concurrent.Callable;
import java.util.concurrent.TimeUnit;

public class BenchmarkUtils {
    public static double opsPerSecByIterations(long numIterations, Callable<?> action) {
        try {
            Stopwatch sw = Stopwatch.createStarted();
            int i = 0;
            while ((long)i < numIterations) {
                action.call();
                ++i;
            }
            long elapsed = sw.elapsed(TimeUnit.NANOSECONDS);
            double ratio = (double)numIterations / ((double)elapsed / 1.0E9);
            return ratio;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static double opsPerSecByTimeLimit(Callable<?> action) {
        try {
            Stopwatch sw = Stopwatch.createStarted();
            int batchSize = 100;
            long limit = TimeUnit.NANOSECONDS.convert(Duration.ofSeconds(1L));
            long elapsed = 0L;
            long done = 0L;
            while (elapsed < limit) {
                for (int i = 0; i < batchSize; ++i) {
                    action.call();
                }
                ++done;
                elapsed = sw.elapsed(TimeUnit.NANOSECONDS);
            }
            double ratio = (double)(done * (long)batchSize) / ((double)elapsed / 1.0E9);
            return ratio;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

