/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.commons.util.xml;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;
import org.xml.sax.InputSource;

public class IgnoreIllegalCharactersXmlReader
extends Reader {
    private final BufferedReader underlyingReader;
    private StringBuilder buffer = new StringBuilder(4096);
    private boolean eos = false;

    public IgnoreIllegalCharactersXmlReader(InputStream is) throws UnsupportedEncodingException {
        this.underlyingReader = new BufferedReader(new InputStreamReader(is, "UTF-8"));
    }

    private void fillBuffer() throws IOException {
        String line = this.underlyingReader.readLine();
        if (line == null) {
            this.eos = true;
            return;
        }
        this.buffer.append(line);
        this.buffer.append('\n');
    }

    @Override
    public int read(char[] cbuf, int off, int len) throws IOException {
        if (this.buffer.length() == 0 && this.eos) {
            return -1;
        }
        int satisfied = 0;
        int currentOffset = off;
        while (!this.eos && this.buffer.length() < len) {
            this.fillBuffer();
        }
        while (satisfied < len && this.buffer.length() > 0) {
            char nextCh;
            char ch = this.buffer.charAt(0);
            char c = nextCh = this.buffer.length() > 1 ? this.buffer.charAt(1) : (char)'\u0000';
            if (ch == '&' && nextCh == '#') {
                StringBuilder entity = new StringBuilder();
                int index = 0;
                char entityCh = '\u0000';
                while (entityCh != ';') {
                    entityCh = this.buffer.charAt(index++);
                    entity.append(entityCh);
                }
                if (entity.toString().equals("&#2;")) {
                    this.buffer.delete(0, entity.length());
                    continue;
                }
            }
            throw new RuntimeException("We need XMLChar.isValid here");
        }
        return satisfied;
    }

    @Override
    public void close() throws IOException {
        this.underlyingReader.close();
    }

    public static <T> T unmarshallXml(Class<T> clazz, InputStream in) throws JAXBException, UnsupportedEncodingException {
        String className = clazz.getPackage().getName();
        JAXBContext context = JAXBContext.newInstance((String)className);
        Unmarshaller unmarshaller = context.createUnmarshaller();
        IgnoreIllegalCharactersXmlReader reader = new IgnoreIllegalCharactersXmlReader(in);
        InputSource is = new InputSource(reader);
        is.setEncoding("UTF-8");
        Object result = unmarshaller.unmarshal(is);
        return (T)result;
    }
}

