/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.commons.utils.trie;

import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.ToIntFunction;
import org.aksw.commons.utils.trie.PatriciaTrieUtils;
import org.apache.commons.collections4.trie.PatriciaTrie;

public class ShortNameMgr {
    protected int namespaceCounter = 0;
    protected PatriciaTrie<String> prefixMap = new PatriciaTrie();
    protected Map<String, Name> shortToFull = new HashMap<String, Name>();
    protected Function<String, String> shortNameSanitizer;
    protected ToIntFunction<CharSequence> nameSplitter;

    public ShortNameMgr clone() {
        ShortNameMgr result = new ShortNameMgr();
        result.namespaceCounter = this.namespaceCounter;
        result.prefixMap = new PatriciaTrie(this.prefixMap);
        result.shortToFull = new HashMap<String, Name>(this.shortToFull);
        result.shortNameSanitizer = this.shortNameSanitizer;
        result.nameSplitter = this.nameSplitter;
        return result;
    }

    public ShortNameMgr() {
        this(null, null);
    }

    public ShortNameMgr(Function<String, String> shortNameSanitizer) {
        this(null, shortNameSanitizer);
    }

    public ShortNameMgr(ToIntFunction<CharSequence> nameSplitter, Function<String, String> shortNameSanitizer) {
        this.nameSplitter = Optional.ofNullable(nameSplitter).orElse(ShortNameMgr::simpleIriSplit);
        this.shortNameSanitizer = shortNameSanitizer;
    }

    public Name allocate(String iri, String label) {
        String localName;
        String ns;
        String matchKey = PatriciaTrieUtils.longestPrefixOf(this.prefixMap, iri);
        String prefix = null;
        if (matchKey != null) {
            ns = matchKey;
            prefix = (String)this.prefixMap.get((Object)matchKey);
            localName = iri.substring(matchKey.length());
        } else {
            int splitPoint = this.nameSplitter.applyAsInt(iri);
            if (splitPoint < 0) {
                splitPoint = iri.length();
            }
            ns = iri.substring(0, splitPoint);
            localName = iri.substring(splitPoint);
            prefix = this.allocPrefix(ns);
            this.prefixMap.put((Object)ns, (Object)prefix);
        }
        if (label != null) {
            localName = label;
        }
        return this.allocate(prefix, ns, localName);
    }

    public Name allocate(String iri) {
        return this.allocate(iri, null);
    }

    protected Name allocate(String prefix, String ns, String localName) {
        String baseName = localName;
        if (baseName.isEmpty()) {
            baseName = "_";
        }
        if (this.shortNameSanitizer != null) {
            baseName = this.shortNameSanitizer.apply(baseName);
        }
        Name result = null;
        Object shortName = baseName;
        int i = 0;
        while (!((result = this.shortToFull.get(shortName)) == null || result.ns().equals(ns) && result.localName().equals(localName))) {
            shortName = baseName + i;
            ++i;
        }
        if (result == null) {
            result = new Name((String)shortName, prefix, ns, localName);
            this.shortToFull.put((String)shortName, result);
        }
        return result;
    }

    protected String allocPrefix(String ns) {
        return "ns" + ++this.namespaceCounter;
    }

    public static int simpleIriSplit(CharSequence cs) {
        int i;
        boolean acceptableCharSeen = false;
        for (i = cs.length() - 1; i >= 0; --i) {
            char c = cs.charAt(i);
            if (c == '/' || c == '#' || c == '.') {
                if (!acceptableCharSeen) continue;
                ++i;
                break;
            }
            acceptableCharSeen = true;
        }
        return i;
    }

    public static void main(String[] args) {
        ShortNameMgr mgr = new ShortNameMgr();
        System.out.println(mgr.allocate("http://foo.bar/Foo"));
        System.out.println(mgr.allocate("http://foo.bar/Bar"));
    }

    public record Name(String shortName, String prefix, String ns, String localName) {
    }
}

