/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.commons.util.gson;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;

public class GsonUtils {
    public static JsonObject setString(JsonObject obj, List<String> keys, String value) {
        return GsonUtils.setElement(obj, keys, (JsonElement)(value == null ? null : new JsonPrimitive(value)));
    }

    public static JsonObject setNumber(JsonObject obj, List<String> keys, Number number) {
        return GsonUtils.setElement(obj, keys, (JsonElement)(number == null ? null : new JsonPrimitive(number)));
    }

    public static JsonObject setElement(JsonObject obj, List<String> keys, JsonElement value) {
        int l = keys.size();
        JsonObject tgt = l == 0 ? obj : GsonUtils.makePath(obj, keys.subList(0, l - 1));
        String key = keys.get(l - 1);
        if (value == null) {
            tgt.remove(key);
        } else {
            tgt.add(key, value);
        }
        return obj;
    }

    public static JsonObject makePath(JsonObject obj, String ... keys) {
        return GsonUtils.makePath(obj, Arrays.asList(keys));
    }

    public static JsonObject makePath(JsonObject obj, List<String> keys) {
        for (String key : keys) {
            JsonElement member = obj.get(key);
            if (member == null) {
                member = new JsonObject();
                obj.add(key, member);
            } else if (!(member instanceof JsonObject)) {
                throw new RuntimeException("Encountered unexpected existing non-object member.");
            }
            obj = (JsonObject)member;
        }
        return obj;
    }

    public static List<String> parsePathSegments(String str) {
        return new ArrayList<String>(Arrays.asList(str.split("\\.")));
    }

    public static JsonElement merge(JsonElement a, JsonElement b) {
        Object result = GsonUtils.isNull(a) ? GsonUtils.copyOrNull(b) : (GsonUtils.isNull(b) ? a : (a.isJsonArray() && b.isJsonArray() ? GsonUtils.merge(a.getAsJsonArray(), b.getAsJsonArray()) : (a.isJsonObject() && b.isJsonObject() ? GsonUtils.merge(a.getAsJsonObject(), b.getAsJsonObject()) : b)));
        return result;
    }

    public static JsonElement merge(JsonObject a, JsonObject b) {
        for (Map.Entry e : b.entrySet()) {
            String k = (String)e.getKey();
            JsonElement x = a.get(k);
            JsonElement y = (JsonElement)e.getValue();
            JsonElement elt = GsonUtils.merge(x, y);
            a.add(k, elt);
        }
        return a;
    }

    public static JsonArray merge(JsonArray a, JsonArray b) {
        HashSet<JsonElement> set = new HashSet<JsonElement>(a.size());
        a.forEach(set::add);
        for (JsonElement item : b) {
            if (set.contains(item)) continue;
            set.add(item);
            a.add(item.deepCopy());
        }
        return a;
    }

    public static boolean isNull(JsonElement elt) {
        return elt == null || elt.isJsonNull();
    }

    public static JsonElement copyOrNull(JsonElement elt) {
        return elt == null ? null : elt.deepCopy();
    }
}

